/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.nodejs;

import io.swagger.codegen.AbstractOptionsTest;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.languages.NodeJSServerCodegen;
import io.swagger.codegen.options.NodeJSServerOptionsProvider;
import mockit.Expectations;
import mockit.Tested;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodeJSServerOptionsTest
extends AbstractOptionsTest {
    @Tested
    private NodeJSServerCodegen clientCodegen;

    public NodeJSServerOptionsTest() {
        super(new NodeJSServerOptionsProvider());
    }

    @Override
    protected CodegenConfig getCodegenConfig() {
        return this.clientCodegen;
    }

    @Override
    protected void setExpectations() {
        new Expectations(new Object[]{this.clientCodegen}){
            {
                NodeJSServerOptionsTest.this.clientCodegen.setSortParamsByRequiredFlag(Boolean.valueOf("false"));
                NodeJSServerOptionsTest.this.clientCodegen.setGoogleCloudFunctions(Boolean.valueOf("false").booleanValue());
                NodeJSServerOptionsTest.this.clientCodegen.setExportedName("exported");
                this.times = 1;
            }
        };
    }

    @Test
    public void testCleanTitle() {
        String dirtyTitle = "safe-title";
        String clean = dirtyTitle.replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[-]*", "").replaceAll("[-]*$", "").replaceAll("[-]{2,}", "-");
        Assert.assertEquals((String)clean, (String)"safe-title");
    }

    @Test
    public void testDirtyTitleCleansing() {
        String dirtyTitle = "_it's-$ooo//////////---_//dirty!!!!";
        String clean = dirtyTitle.replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[-]*", "").replaceAll("[-]*$", "").replaceAll("[-]{2,}", "-");
        Assert.assertEquals((String)clean, (String)"it-s-ooo-dirty");
    }
}

