/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.mustache;

import io.swagger.codegen.mustache.MustacheTestBase;
import io.swagger.codegen.mustache.TitlecaseLambda;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TitlecaseLambdaTest
extends MustacheTestBase {
    private String template = "{{#titlecase}}{{value}}{{/titlecase}}";

    @Test(description="title cases single word")
    public void testTitlecase() throws Exception {
        String input = "single";
        String expected = "Single";
        Object ctx = this.context("titlecase", new TitlecaseLambda(), "value", input);
        String actual = this.compile(this.template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(description="title cases multiple words based on custom delimeter")
    public void testTitlecaseCustomDelim() throws Exception {
        String input = "one|or|more|words";
        String expected = "One|Or|More|Words";
        Object ctx = this.context("titlecase", new TitlecaseLambda("|"), "value", input);
        String actual = this.compile(this.template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(description="title cases first word when delim is null")
    public void testTitlecaseFirstWord() throws Exception {
        String input = "one or more words";
        String expected = "One or more words";
        Object ctx = this.context("titlecase", new TitlecaseLambda(null), "value", input);
        String actual = this.compile(this.template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(description="title cases multiple words")
    public void testTitlecaseMultipleWords() throws Exception {
        String input = "one or more words";
        String expected = "One Or More Words";
        Object ctx = this.context("titlecase", new TitlecaseLambda(), "value", input);
        String actual = this.compile(this.template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }
}

