/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.mustache;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.languages.CSharpClientCodegen;
import io.swagger.codegen.mustache.LowercaseLambda;
import io.swagger.codegen.mustache.MustacheTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LowercaseLambdaTest
extends MustacheTestBase {
    @Test(description="lowercases expected inputs")
    public void testExecute() throws Exception {
        String template = "{{#lowercase}}{{value}}{{/lowercase}}";
        Object lowercaseCtx = this.context("lowercase", new LowercaseLambda(), "value", "lowercase input");
        Object uppercaseCtx = this.context("lowercase", new LowercaseLambda(), "value", "UPPERCASE INPUT");
        String lowercaseResult = this.compile(template, lowercaseCtx);
        String uppercaseResult = this.compile(template, uppercaseCtx);
        Assert.assertEquals((String)lowercaseResult, (String)"lowercase input");
        Assert.assertEquals((String)uppercaseResult, (String)"uppercase input");
    }

    @Test(description="lowercase escapes reserved words")
    public void testEscapingReservedWords() {
        String template = "{{#lowercase}}{{value}}{{/lowercase}}";
        String expected = "_class";
        Object ctx = this.context("lowercase", new LowercaseLambda().generator((CodegenConfig)new CSharpClientCodegen()), "value", "CLASS");
        String actual = this.compile(template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }
}

