/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.mustache;

import io.swagger.codegen.mustache.IndentedLambda;
import io.swagger.codegen.mustache.MustacheTestBase;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IndentedLambdaTest
extends MustacheTestBase {
    @Test(description="indents by 4 spaces by default")
    public void testFourSpaceIndent() throws Exception {
        String indent = StringUtils.repeat((String)" ", (int)4);
        String template = "    {{#indent_4}}{{value}}{{/indent_4}}";
        String input = StringUtils.join(Arrays.asList("line1", "line2", "", "line3"), (String)System.lineSeparator());
        String expected = StringUtils.join(Arrays.asList(indent + "line1", indent + "line2", indent + "", indent + "line3"), (String)System.lineSeparator());
        Object ctx = this.context("indent_4", new IndentedLambda(), "value", input);
        String actual = this.compile(template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test
    public void testCustomCountAndDelim() throws Exception {
        int count = 12;
        String delim = ".";
        String indent = StringUtils.repeat((String)delim, (int)count);
        String template = indent + "{{#indent_" + count + "}}{{value}}{{/indent_" + count + "}}";
        String input = StringUtils.join(Arrays.asList("line1", "line2", "", "line3"), (String)System.lineSeparator());
        String expected = StringUtils.join(Arrays.asList(indent + "line1", indent + "line2", indent + "", indent + "line3"), (String)System.lineSeparator());
        Object ctx = this.context("indent_" + count, new IndentedLambda(count, delim), "value", input);
        String actual = this.compile(template, ctx);
        Assert.assertEquals((String)actual, (String)expected);
    }

    @Test(description="throws illegal arg for count < 0.", expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="prefixSpaceCount must be greater than 0")
    public void testRequiresValidCount() throws Exception {
        int count = -1;
        IndentedLambda instance = new IndentedLambda(count, " ");
    }
}

