/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.mustache;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.languages.CSharpClientCodegen;
import io.swagger.codegen.languages.ScalaClientCodegen;
import io.swagger.codegen.mustache.CamelCaseLambda;
import io.swagger.codegen.mustache.MustacheTestBase;
import org.testng.Assert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

public class CamelCaseLambdaTest
extends MustacheTestBase {
    private final String input;
    private final String expected;
    private Boolean escapeAsParamName = false;
    private CodegenConfig generator = null;

    public CamelCaseLambdaTest(String input, String expected) {
        this.input = input;
        this.expected = expected;
    }

    public CamelCaseLambdaTest generator(CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    public CamelCaseLambdaTest escapeAsParamName(Boolean setting) {
        this.escapeAsParamName = setting;
        return this;
    }

    @Test(description="camelCase expected inputs")
    public void testExecute() throws Exception {
        String template = "{{#camelcase}}{{value}}{{/camelcase}}";
        Object inputCtx = this.context("camelcase", new CamelCaseLambda().generator(this.generator).escapeAsParamName(this.escapeAsParamName), "value", this.input);
        String actual = this.compile(template, inputCtx);
        Assert.assertEquals((String)actual, (String)this.expected);
    }

    @Factory
    public static Object[] factoryMethod() {
        return new Object[]{new CamelCaseLambdaTest("lowercase input", "lowercase input"), new CamelCaseLambdaTest("UPPERCASE INPUT", "uPPERCASE INPUT"), new CamelCaseLambdaTest("inputText", "inputText"), new CamelCaseLambdaTest("input_text", "inputText"), new CamelCaseLambdaTest("INPUT_TEXT", "iNPUTTEXT"), new CamelCaseLambdaTest("input-text", "inputText"), new CamelCaseLambdaTest("input-text input-text input-text input-text input-text", "inputText inputText inputText inputText inputText"), new CamelCaseLambdaTest("class", "_class").generator((CodegenConfig)new CSharpClientCodegen()), new CamelCaseLambdaTest("123List", "_123List").generator((CodegenConfig)new CSharpClientCodegen()).escapeAsParamName(true), new CamelCaseLambdaTest("class", "`class`").generator((CodegenConfig)new ScalaClientCodegen())};
    }
}

