/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaJAXRSSpecServerCodegen;
import org.junit.Test;
import org.testng.Assert;

public class JavaJAXRSSpecServerCodegenTest {
    private JavaJAXRSSpecServerCodegen generator = new JavaJAXRSSpecServerCodegen();

    @Test
    public void do_not_process_RestApplication_when_interfaceOnly_is_true() {
        this.generator.additionalProperties().put("interfaceOnly", "true");
        this.generator.processOpts();
        for (SupportingFile file : this.generator.supportingFiles()) {
            Assert.assertNotEquals((Object)"RestApplication.mustache", (Object)file.templateFile);
        }
    }

    @Test
    public void do_process_pom_by_default() {
        this.generator.processOpts();
        for (SupportingFile file : this.generator.supportingFiles()) {
            if (!"pom.mustache".equals(file.templateFile)) continue;
            return;
        }
        Assert.fail((String)"Missing pom.mustache");
    }

    @Test
    public void process_pom_if_generatePom_is_true() {
        this.generator.additionalProperties().put("generatePom", "true");
        this.generator.processOpts();
        for (SupportingFile file : this.generator.supportingFiles()) {
            if (!"pom.mustache".equals(file.templateFile)) continue;
            return;
        }
        Assert.fail((String)"Missing pom.mustache");
    }

    @Test
    public void do_not_process_pom_if_generatePom_is_false() {
        this.generator.additionalProperties().put("generatePom", "false");
        this.generator.processOpts();
        for (SupportingFile file : this.generator.supportingFiles()) {
            Assert.assertNotEquals((Object)"pom.mustache", (Object)file.templateFile);
        }
    }

    @Test
    public void verify_that_generatePom_exists_as_a_parameter_with_default_true() {
        for (CliOption option : this.generator.cliOptions()) {
            if (!option.getOpt().equals("generatePom")) continue;
            Assert.assertEquals((String)"boolean", (String)option.getType());
            Assert.assertEquals((String)"true", (String)option.getDefault());
            return;
        }
        Assert.fail((String)"Missing generatePom");
    }

    @Test
    public void verify_that_returnResponse_is_removed_from_additional_properties_if_false() {
        this.generator.additionalProperties().put("returnResponse", Boolean.FALSE.toString());
        this.generator.processOpts();
        Assert.assertFalse((boolean)this.generator.additionalProperties().containsKey("returnResponse"));
    }

    @Test
    public void verify_that_returnResponse_is_preserved_in_additional_properties_if_true() {
        this.generator.additionalProperties().put("returnResponse", Boolean.TRUE.toString());
        this.generator.processOpts();
        Assert.assertTrue((boolean)this.generator.additionalProperties().containsKey("returnResponse"));
    }

    @Test
    public void verify_that_interfaceOnly_exists_as_a_parameter_with_default_false() {
        for (CliOption option : this.generator.cliOptions()) {
            if (!option.getOpt().equals("interfaceOnly")) continue;
            Assert.assertEquals((String)"boolean", (String)option.getType());
            Assert.assertEquals((String)"false", (String)option.getDefault());
            return;
        }
        Assert.fail((String)"Missing interfaceOnly");
    }

    @Test
    public void verify_that_interfaceOnly_is_removed_from_additional_properties_if_false() {
        this.generator.additionalProperties().put("interfaceOnly", Boolean.FALSE.toString());
        this.generator.processOpts();
        Assert.assertFalse((boolean)this.generator.additionalProperties().containsKey("interfaceOnly"));
    }

    @Test
    public void verify_that_interfaceOnly_is_preserved_in_additional_properties_if_true() {
        this.generator.additionalProperties().put("interfaceOnly", Boolean.TRUE.toString());
        this.generator.processOpts();
        Assert.assertTrue((boolean)this.generator.additionalProperties().containsKey("interfaceOnly"));
    }
}

