/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.languages.JavaClientCodegen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavaClientCodegenTest {
    private static final String VENDOR_MIME_TYPE = "application/vnd.company.v1+json";
    private static final String XML_MIME_TYPE = "application/xml";
    private static final String JSON_MIME_TYPE = "application/json";
    private static final String TEXT_MIME_TYPE = "text/plain";

    @Test
    public void testJsonMime() {
        Assert.assertTrue((boolean)JavaClientCodegen.isJsonMimeType((String)JSON_MIME_TYPE));
        Assert.assertFalse((boolean)JavaClientCodegen.isJsonMimeType((String)XML_MIME_TYPE));
        Assert.assertFalse((boolean)JavaClientCodegen.isJsonMimeType((String)TEXT_MIME_TYPE));
        Assert.assertTrue((boolean)JavaClientCodegen.isJsonVendorMimeType((String)"application/vnd.mycompany+json"));
        Assert.assertTrue((boolean)JavaClientCodegen.isJsonVendorMimeType((String)"application/vnd.mycompany.v1+json"));
        Assert.assertTrue((boolean)JavaClientCodegen.isJsonVendorMimeType((String)"application/vnd.mycompany.resourceTypeA.version1+json"));
        Assert.assertTrue((boolean)JavaClientCodegen.isJsonVendorMimeType((String)"application/vnd.mycompany.resourceTypeB.version2+json"));
        Assert.assertFalse((boolean)JavaClientCodegen.isJsonVendorMimeType((String)"application/v.json"));
    }

    @Test
    public void testContentTypePrioritization() {
        HashMap<String, String> jsonMimeType = new HashMap<String, String>();
        jsonMimeType.put("mediaType", JSON_MIME_TYPE);
        HashMap<String, String> xmlMimeType = new HashMap<String, String>();
        xmlMimeType.put("mediaType", XML_MIME_TYPE);
        HashMap<String, String> vendorMimeType = new HashMap<String, String>();
        vendorMimeType.put("mediaType", VENDOR_MIME_TYPE);
        HashMap<String, String> textMimeType = new HashMap<String, String>();
        textMimeType.put("mediaType", TEXT_MIME_TYPE);
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Collections.emptyList()), Collections.emptyList());
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(xmlMimeType)), Arrays.asList(xmlMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(jsonMimeType)), Arrays.asList(jsonMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(vendorMimeType)), Arrays.asList(vendorMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(xmlMimeType, jsonMimeType)), Arrays.asList(jsonMimeType, xmlMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(jsonMimeType, xmlMimeType)), Arrays.asList(jsonMimeType, xmlMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(jsonMimeType, vendorMimeType)), Arrays.asList(vendorMimeType, jsonMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(textMimeType, xmlMimeType)), Arrays.asList(textMimeType, xmlMimeType));
        Assert.assertEquals((Collection)JavaClientCodegen.prioritizeContentTypes(Arrays.asList(xmlMimeType, textMimeType)), Arrays.asList(xmlMimeType, textMimeType));
        System.out.println(JavaClientCodegen.prioritizeContentTypes(Arrays.asList(xmlMimeType, textMimeType, jsonMimeType, vendorMimeType)));
        List priContentTypes = JavaClientCodegen.prioritizeContentTypes(Arrays.asList(xmlMimeType, textMimeType, jsonMimeType, vendorMimeType));
        Assert.assertEquals((Collection)priContentTypes, Arrays.asList(vendorMimeType, jsonMimeType, xmlMimeType, textMimeType));
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull(((Map)priContentTypes.get(i)).get("hasMore"));
        }
        Assert.assertNull(((Map)priContentTypes.get(3)).get("hasMore"));
    }

    @Test
    public void testParametersAreCorrectlyOrderedWhenUsingRetrofit() {
        JavaClientCodegen javaClientCodegen = new JavaClientCodegen();
        javaClientCodegen.setLibrary("retrofit2");
        CodegenOperation codegenOperation = new CodegenOperation();
        CodegenParameter queryParamRequired = this.createQueryParam("queryParam1", true);
        CodegenParameter queryParamOptional = this.createQueryParam("queryParam2", false);
        CodegenParameter pathParam1 = this.createPathParam("pathParam1");
        CodegenParameter pathParam2 = this.createPathParam("pathParam2");
        codegenOperation.allParams = Arrays.asList(queryParamRequired, pathParam1, pathParam2, queryParamOptional);
        ImmutableMap operations = ImmutableMap.of((Object)"operation", Arrays.asList(codegenOperation));
        ImmutableMap objs = ImmutableMap.of((Object)"operations", (Object)operations, (Object)"imports", new ArrayList());
        javaClientCodegen.postProcessOperations((Map)objs);
        Assert.assertEquals(Arrays.asList(pathParam1, pathParam2, queryParamRequired, queryParamOptional), (Collection)codegenOperation.allParams);
        Assert.assertTrue((boolean)pathParam1.hasMore);
        Assert.assertTrue((boolean)pathParam2.hasMore);
        Assert.assertTrue((boolean)queryParamRequired.hasMore);
        Assert.assertFalse((boolean)queryParamOptional.hasMore);
    }

    @Test
    public void testInitialConfigValues() throws Exception {
        JavaClientCodegen codegen = new JavaClientCodegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"io.swagger.client.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"io.swagger.client.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"io.swagger.client.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"io.swagger.client.api");
        Assert.assertEquals((String)codegen.invokerPackage, (String)"io.swagger.client");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"io.swagger.client");
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        JavaClientCodegen codegen = new JavaClientCodegen();
        codegen.setHideGenerationTimestamp(true);
        codegen.setModelPackage("xyz.yyyyy.zzzzzzz.model");
        codegen.setApiPackage("xyz.yyyyy.zzzzzzz.api");
        codegen.setInvokerPackage("xyz.yyyyy.zzzzzzz.invoker");
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.zzzzzzz.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.zzzzzzz.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"xyz.yyyyy.zzzzzzz.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"xyz.yyyyy.zzzzzzz.api");
        Assert.assertEquals((String)codegen.invokerPackage, (String)"xyz.yyyyy.zzzzzzz.invoker");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.zzzzzzz.invoker");
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        JavaClientCodegen codegen = new JavaClientCodegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", "true");
        codegen.additionalProperties().put("modelPackage", "xyz.yyyyy.zzzzzzz.mmmmm.model");
        codegen.additionalProperties().put("apiPackage", "xyz.yyyyy.zzzzzzz.aaaaa.api");
        codegen.additionalProperties().put("invokerPackage", "xyz.yyyyy.zzzzzzz.iiii.invoker");
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"xyz.yyyyy.zzzzzzz.aaaaa.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"xyz.yyyyy.zzzzzzz.aaaaa.api");
        Assert.assertEquals((String)codegen.invokerPackage, (String)"xyz.yyyyy.zzzzzzz.iiii.invoker");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.zzzzzzz.iiii.invoker");
    }

    @Test
    public void testPackageNamesSetInvokerDerivedFromApi() throws Exception {
        JavaClientCodegen codegen = new JavaClientCodegen();
        codegen.additionalProperties().put("modelPackage", "xyz.yyyyy.zzzzzzz.mmmmm.model");
        codegen.additionalProperties().put("apiPackage", "xyz.yyyyy.zzzzzzz.aaaaa.api");
        codegen.processOpts();
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"xyz.yyyyy.zzzzzzz.aaaaa.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"xyz.yyyyy.zzzzzzz.aaaaa.api");
        Assert.assertEquals((String)codegen.invokerPackage, (String)"xyz.yyyyy.zzzzzzz.aaaaa");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.zzzzzzz.aaaaa");
    }

    @Test
    public void testPackageNamesSetInvokerDerivedFromModel() throws Exception {
        JavaClientCodegen codegen = new JavaClientCodegen();
        codegen.additionalProperties().put("modelPackage", "xyz.yyyyy.zzzzzzz.mmmmm.model");
        codegen.processOpts();
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.zzzzzzz.mmmmm.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"io.swagger.client.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"io.swagger.client.api");
        Assert.assertEquals((String)codegen.invokerPackage, (String)"xyz.yyyyy.zzzzzzz.mmmmm");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.zzzzzzz.mmmmm");
    }

    private CodegenParameter createPathParam(String name) {
        CodegenParameter codegenParameter = this.createStringParam(name);
        codegenParameter.isPathParam = true;
        return codegenParameter;
    }

    private CodegenParameter createQueryParam(String name, boolean required) {
        CodegenParameter codegenParameter = this.createStringParam(name);
        codegenParameter.isQueryParam = true;
        codegenParameter.required = required;
        return codegenParameter;
    }

    private CodegenParameter createStringParam(String name) {
        CodegenParameter codegenParameter = new CodegenParameter();
        codegenParameter.paramName = name;
        codegenParameter.baseName = name;
        codegenParameter.dataType = "String";
        return codegenParameter;
    }
}

