/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.languages.ClojureClientCodegen;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClojureClientCodegenTest {
    ClojureClientCodegen codegen = new ClojureClientCodegen();

    @Test
    public void testSanitizeTag() throws Exception {
        Assert.assertEquals((String)this.codegen.sanitizeTag("users-api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.sanitizeTag("users_api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.sanitizeTag("users api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.sanitizeTag("users.api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.sanitizeTag("Users Api"), (String)"Users_Api");
        Assert.assertEquals((String)this.codegen.sanitizeTag("UsersApi"), (String)"UsersApi");
        Assert.assertEquals((String)this.codegen.sanitizeTag("usersapi"), (String)"usersapi");
        Assert.assertEquals((String)this.codegen.sanitizeTag("Usersapi"), (String)"Usersapi");
    }

    @Test
    public void testToApiName() throws Exception {
        Assert.assertEquals((String)this.codegen.toApiName("users_api"), (String)"users-api");
        Assert.assertEquals((String)this.codegen.toApiName("Users_Api"), (String)"users-api");
        Assert.assertEquals((String)this.codegen.toApiName("UsersApi"), (String)"users-api");
        Assert.assertEquals((String)this.codegen.toApiName("usersapi"), (String)"usersapi");
        Assert.assertEquals((String)this.codegen.toApiName("Usersapi"), (String)"usersapi");
    }

    @Test
    public void testToApiFilename() throws Exception {
        Assert.assertEquals((String)this.codegen.toApiFilename("users_api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.toApiFilename("Users_Api"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.toApiFilename("UsersApi"), (String)"users_api");
        Assert.assertEquals((String)this.codegen.toApiFilename("usersapi"), (String)"usersapi");
        Assert.assertEquals((String)this.codegen.toApiFilename("Usersapi"), (String)"usersapi");
    }
}

