/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.DefaultCodegen;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BooleanOptionsTest {
    private static final String OPTIONS_PROVIDER = "Codegen";

    @DataProvider(name="Codegen")
    private Iterator<Object[]> listOptions() throws IllegalAccessException, InstantiationException {
        String packageName = "io.swagger.codegen.languages";
        Reflections reflections = new Reflections("io.swagger.codegen.languages", new Scanner[0]);
        ArrayList<Object[]> codegenList = new ArrayList<Object[]>();
        for (Class codegen : reflections.getSubTypesOf(DefaultCodegen.class)) {
            if (Modifier.isAbstract(codegen.getModifiers())) continue;
            codegenList.add(new Object[]{codegen.newInstance()});
        }
        if (codegenList.size() == 0) {
            Assert.fail((String)String.format("No classes for testing have been found in the package %s", "io.swagger.codegen.languages"));
        }
        return codegenList.iterator();
    }

    @Test(dataProvider="Codegen")
    public void booleanOptionsTest(DefaultCodegen codegen) {
        for (CliOption option : codegen.cliOptions()) {
            if (!option.getType().equals("boolean")) continue;
            Assert.assertNotNull((Object)option.getDefault());
            Assert.assertTrue((option.getDefault().equals(Boolean.TRUE.toString()) || option.getDefault().equals(Boolean.FALSE.toString()) ? 1 : 0) != 0);
        }
    }
}

