/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.languages.AbstractScalaCodegen;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class AbstractScalaCodegenTest {
    private AbstractScalaCodegen abstractScalaCodegen;

    @BeforeTest
    public void setup() {
        this.abstractScalaCodegen = new FakeScalaCodeGen();
    }

    @Test
    public void shouldCamelCase() {
        String className = "models.WebsiteBodyModel";
        String result = this.abstractScalaCodegen.formatIdentifier(className, false);
        Assert.assertTrue((boolean)"modelsWebsiteBodyModel".equals(result));
    }

    @Test
    public void shouldCamelCaseAndUpperCase() {
        String className = "models.WebsiteBodyModel";
        String result = this.abstractScalaCodegen.formatIdentifier(className, true);
        Assert.assertTrue((boolean)"ModelsWebsiteBodyModel".equals(result));
    }

    @Test
    public void shouldEscapeReservedWords() {
        String className = "ReservedWord";
        String result = this.abstractScalaCodegen.formatIdentifier(className, true);
        Assert.assertTrue((boolean)"`ReservedWord`".equals(result));
    }

    @Test
    public void shouldReturnSameInputWhenNull() {
        String result = this.abstractScalaCodegen.stripPackageName(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void shouldReturnSameInputWhenEmpty() {
        String input = "";
        String result = this.abstractScalaCodegen.stripPackageName(input);
        Assert.assertSame((Object)result, (Object)input);
    }

    @Test
    public void shouldReturnSameInputWhenValid() {
        String input = "WebsiteBodyModel";
        String result = this.abstractScalaCodegen.stripPackageName(input);
        Assert.assertSame((Object)result, (Object)input);
    }

    @Test
    public void shouldStripPackageName() {
        String input = "models.WebsiteBodyModel";
        String result = this.abstractScalaCodegen.stripPackageName(input);
        Assert.assertEquals((String)result, (String)"WebsiteBodyModel");
    }

    private class FakeScalaCodeGen
    extends AbstractScalaCodegen {
        public FakeScalaCodeGen() {
            this.reservedWords.add("reservedword");
        }
    }
}

