/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.lagomScalaApi;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.ScalaClientCodegen;
import io.swagger.codegen.languages.ScalaLagomServerCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LagomScalaApiModelTest {
    @Test(description="convert a simple scala model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        ScalaLagomServerCodegen codegen = new ScalaLagomServerCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.getter, (String)"getId");
        Assert.assertEquals((String)property1.setter, (String)"setId");
        Assert.assertEquals((String)property1.datatype, (String)"Long");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"Long");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.getter, (String)"getName");
        Assert.assertEquals((String)property2.setter, (String)"setName");
        Assert.assertEquals((String)property2.datatype, (String)"String");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"String");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property3.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property3.datatype, (String)"DateTime");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"DateTime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property1.baseName, (String)"urls");
        Assert.assertEquals((String)property1.getter, (String)"getUrls");
        Assert.assertEquals((String)property1.setter, (String)"setUrls");
        Assert.assertEquals((String)property1.datatype, (String)"List[String]");
        Assert.assertEquals((String)property1.name, (String)"urls");
        Assert.assertEquals((String)property1.defaultValue, (String)"new ListBuffer[String]() ");
        Assert.assertEquals((String)property1.baseType, (String)"List");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.getter, (String)"getTranslations");
        Assert.assertEquals((String)property1.setter, (String)"setTranslations");
        Assert.assertEquals((String)property1.datatype, (String)"Map[String, String]");
        Assert.assertEquals((String)property1.name, (String)"translations");
        Assert.assertEquals((String)property1.defaultValue, (String)"new HashMap[String, String]() ");
        Assert.assertEquals((String)property1.baseType, (String)"Map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex properties")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.getter, (String)"getChildren");
        Assert.assertEquals((String)property1.setter, (String)"setChildren");
        Assert.assertEquals((String)property1.datatype, (String)"Children");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.getter, (String)"getChildren");
        Assert.assertEquals((String)property1.setter, (String)"setChildren");
        Assert.assertEquals((String)property1.datatype, (String)"List[Children]");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.defaultValue, (String)"new ListBuffer[Children]() ");
        Assert.assertEquals((String)property1.baseType, (String)"List");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.getter, (String)"getChildren");
        Assert.assertEquals((String)property1.setter, (String)"setChildren");
        Assert.assertEquals((String)property1.datatype, (String)"Map[String, Children]");
        Assert.assertEquals((String)property1.name, (String)"children");
        Assert.assertEquals((String)property1.defaultValue, (String)"new HashMap[String, Children]() ");
        Assert.assertEquals((String)property1.baseType, (String)"Map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"ListBuffer[Children]");
        Assert.assertEquals((int)cm.imports.size(), (int)2);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"ListBuffer", "Children"})).size(), (int)2);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        ScalaClientCodegen codegen = new ScalaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"HashMap[String, Children]");
        Assert.assertEquals((int)cm.imports.size(), (int)2);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"HashMap", "Children"})).size(), (int)2);
    }
}

