/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.kotlin;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.KotlinClientCodegen;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class KotlinClientCodegenModelTest {
    private Model getArrayTestModel() {
        return new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("examples", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
    }

    private Model getSimpleModel() {
        return new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
    }

    private Model getMapModel() {
        return new ModelImpl().description("a sample model").property("mapping", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
    }

    private Model getComplexModel() {
        return new ModelImpl().description("a sample model").property("child", (Property)new RefProperty("#/definitions/Child"));
    }

    @Test(description="convert a simple model")
    public void simpleModelTest() {
        Model model = this.getSimpleModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"kotlin.Long");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"kotlin.Long");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"kotlin.String");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"kotlin.String");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"java.time.LocalDateTime");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"java.time.LocalDateTime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a simple model: threetenbp")
    public void selectDateLibraryAsThreetenbp() {
        Model model = this.getSimpleModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        codegen.setDateLibrary(KotlinClientCodegen.DateLibrary.THREETENBP.value);
        codegen.processOpts();
        CodegenModel cm = codegen.fromModel("sample", model);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"org.threeten.bp.LocalDateTime");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"org.threeten.bp.LocalDateTime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a simple model: date string")
    public void selectDateLibraryAsString() {
        Model model = this.getSimpleModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        codegen.setDateLibrary(KotlinClientCodegen.DateLibrary.STRING.value);
        codegen.processOpts();
        CodegenModel cm = codegen.fromModel("sample", model);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"kotlin.String");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"kotlin.String");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a simple model: date java8")
    public void selectDateLibraryAsJava8() {
        Model model = this.getSimpleModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        codegen.setDateLibrary(KotlinClientCodegen.DateLibrary.JAVA8.value);
        codegen.processOpts();
        CodegenModel cm = codegen.fromModel("sample", model);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"java.time.LocalDateTime");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"java.time.LocalDateTime");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with array property to default kotlin.Array")
    public void arrayPropertyTest() {
        Model model = this.getArrayTestModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        CodegenModel generated = codegen.fromModel("sample", model);
        Assert.assertEquals((String)generated.name, (String)"sample");
        Assert.assertEquals((String)generated.classname, (String)"Sample");
        Assert.assertEquals((String)generated.description, (String)"a sample model");
        Assert.assertEquals((int)generated.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)generated.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"examples");
        Assert.assertEquals((String)property.getter, (String)"getExamples");
        Assert.assertEquals((String)property.setter, (String)"setExamples");
        Assert.assertEquals((String)property.datatype, (String)"kotlin.Array<kotlin.String>");
        Assert.assertEquals((String)property.name, (String)"examples");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"kotlin.Array");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        Model model = this.getMapModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"mapping");
        Assert.assertEquals((String)property1.datatype, (String)"kotlin.collections.Map<kotlin.String, kotlin.String>");
        Assert.assertEquals((String)property1.name, (String)"mapping");
        Assert.assertEquals((String)property1.baseType, (String)"kotlin.collections.Map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        Model model = this.getComplexModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"child");
        Assert.assertEquals((String)property1.datatype, (String)"Child");
        Assert.assertEquals((String)property1.name, (String)"child");
        Assert.assertEquals((String)property1.baseType, (String)"Child");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @DataProvider(name="modelNames")
    public static Object[][] modelNames() {
        return new Object[][]{{"TestNs.TestClass", new ModelNameTest("TestNs.TestClass", "TestNsTestClass")}, {"$", new ModelNameTest("$", "Dollar")}, {"for", new ModelNameTest("`for`", "For")}, {"One<Two", new ModelNameTest("One<Two", "OneLessThanTwo")}, {"this is a test", new ModelNameTest("this is a test", "ThisIsATest")}};
    }

    @Test(dataProvider="modelNames", description="sanitize model names")
    public void sanitizeModelNames(String name, ModelNameTest testCase) {
        Model model = this.getComplexModel();
        KotlinClientCodegen codegen = new KotlinClientCodegen();
        CodegenModel cm = codegen.fromModel(name, model);
        Assert.assertEquals((String)cm.name, (String)testCase.expectedName);
        Assert.assertEquals((String)cm.classname, (String)testCase.expectedClassName);
    }

    private static class ModelNameTest {
        private String expectedName;
        private String expectedClassName;

        private ModelNameTest(String nameAndClass) {
            this.expectedName = nameAndClass;
            this.expectedClassName = nameAndClass;
        }

        private ModelNameTest(String expectedName, String expectedClassName) {
            this.expectedName = expectedName;
            this.expectedClassName = expectedClassName;
        }
    }
}

