/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.javascript;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.config.CodegenConfigurator;
import io.swagger.codegen.languages.JavascriptClientCodegen;
import java.io.File;
import java.io.IOException;
import org.junit.rules.TemporaryFolder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavascriptClientCodegenTest {
    @Test
    public void testInitialConfigValues() throws Exception {
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), null);
        Assert.assertEquals((String)codegen.apiPackage(), (String)"api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), null);
        Assert.assertEquals((String)codegen.getInvokerPackage(), null);
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), null);
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        codegen.setHideGenerationTimestamp(false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", false);
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
    }

    @Test
    public void testRecursiveModel() throws IOException {
        TemporaryFolder folder = new TemporaryFolder();
        folder.create();
        File output = folder.getRoot();
        CodegenConfigurator configurator = new CodegenConfigurator().setLang("javascript").setInputSpec("src/test/resources/2_0/recursive_model.yaml").setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = configurator.toClientOptInput();
        new DefaultGenerator().opts(clientOptInput).generate();
        File orderFile = new File(output, "src/api/TestClassApi.js");
        Assert.assertTrue((boolean)orderFile.exists());
        folder.delete();
    }
}

