/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.javascript;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavascriptClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaScriptModelTest {
    @Test(description="convert a simple java model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty().example("Tony")).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        List vars = cm.vars;
        CodegenProperty property1 = (CodegenProperty)vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.getter, (String)"getId");
        Assert.assertEquals((String)property1.setter, (String)"setId");
        Assert.assertEquals((String)property1.datatype, (String)"Number");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, null);
        Assert.assertEquals((String)property1.baseType, (String)"Number");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.getter, (String)"getName");
        Assert.assertEquals((String)property2.setter, (String)"setName");
        Assert.assertEquals((String)property2.datatype, (String)"String");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, null);
        Assert.assertEquals((String)property2.baseType, (String)"String");
        Assert.assertEquals((String)property2.example, (String)"Tony");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property3.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property3.datatype, (String)"Date");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, null);
        Assert.assertEquals((String)property3.baseType, (String)"Date");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"urls");
        Assert.assertEquals((String)property.getter, (String)"getUrls");
        Assert.assertEquals((String)property.setter, (String)"setUrls");
        Assert.assertEquals((String)property.datatype, (String)"[String]");
        Assert.assertEquals((String)property.name, (String)"urls");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Array");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"translations");
        Assert.assertEquals((String)property.getter, (String)"getTranslations");
        Assert.assertEquals((String)property.setter, (String)"setTranslations");
        Assert.assertEquals((String)property.datatype, (String)"{String: String}");
        Assert.assertEquals((String)property.name, (String)"translations");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Object");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a map with complex list property")
    public void mapWithListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new ArrayProperty().items((Property)new RefProperty("Pet")))).required("id");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"translations");
        Assert.assertEquals((String)property.getter, (String)"getTranslations");
        Assert.assertEquals((String)property.setter, (String)"setTranslations");
        Assert.assertEquals((String)property.datatype, (String)"{String: [Pet]}");
        Assert.assertEquals((String)property.name, (String)"translations");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Object");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a 2D list property")
    public void list2DPropertyTest() {
        ModelImpl model = new ModelImpl().name("sample").property("list2D", (Property)new ArrayProperty().items((Property)new ArrayProperty().items((Property)new RefProperty("Pet"))));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"list2D");
        Assert.assertEquals((String)property.getter, (String)"getList2D");
        Assert.assertEquals((String)property.setter, (String)"setList2D");
        Assert.assertEquals((String)property.datatype, (String)"[[Pet]]");
        Assert.assertEquals((String)property.name, (String)"list2D");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Array");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with complex properties")
    public void complexPropertiesTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"Children");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Children");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.complexType, (String)"Children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Array");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.complexType, (String)"Children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"{String: Children}");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Object");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
        Assert.assertFalse((boolean)property.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"Array<Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(description="convert a map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("an map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"Object<String, Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(description="convert a model with uppercase property names")
    public void upperCaseNamesTest() {
        ModelImpl model = new ModelImpl().description("a model with uppercase property names").property("NAME", (Property)new StringProperty()).required("NAME");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"NAME");
        Assert.assertEquals((String)property.getter, (String)"getNAME");
        Assert.assertEquals((String)property.setter, (String)"setNAME");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"NAME");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a model with a 2nd char uppercase property names")
    public void secondCharUpperCaseNamesTest() {
        ModelImpl model = new ModelImpl().description("a model with a 2nd char uppercase property names").property("pId", (Property)new StringProperty()).required("pId");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"pId");
        Assert.assertEquals((String)property.getter, (String)"getPId");
        Assert.assertEquals((String)property.setter, (String)"setPId");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"pId");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert hyphens per issue 503")
    public void hyphensTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("created-at", (Property)new DateTimeProperty());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"created-at");
        Assert.assertEquals((String)property.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property.name, (String)"createdAt");
    }

    @Test(description="convert query[password] to queryPassword")
    public void squareBracketsTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("query[password]", (Property)new StringProperty());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"query[password]");
        Assert.assertEquals((String)property.getter, (String)"getQueryPassword");
        Assert.assertEquals((String)property.setter, (String)"setQueryPassword");
        Assert.assertEquals((String)property.name, (String)"queryPassword");
    }

    @Test(description="properly escape names per 567")
    public void escapeNamesTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("created-at", (Property)new DateTimeProperty());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("with.dots", (Model)model);
        Assert.assertEquals((String)cm.classname, (String)"WithDots");
    }

    @Test(description="convert a model with binary data")
    public void binaryDataTest() {
        ModelImpl model = new ModelImpl().description("model with binary").property("inputBinaryData", (Property)new ByteArrayProperty());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"inputBinaryData");
        Assert.assertEquals((String)property.getter, (String)"getInputBinaryData");
        Assert.assertEquals((String)property.setter, (String)"setInputBinaryData");
        Assert.assertEquals((String)property.datatype, (String)"Blob");
        Assert.assertEquals((String)property.name, (String)"inputBinaryData");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Blob");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="translate an invalid param name")
    public void invalidParamNameTest() {
        ModelImpl model = new ModelImpl().description("a model with a 2nd char uppercase property name").property("_", (Property)new StringProperty());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"_");
        Assert.assertEquals((String)property.getter, (String)"getU");
        Assert.assertEquals((String)property.setter, (String)"setU");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"u");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a parameter")
    public void convertParameterTest() {
        QueryParameter parameter = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().property((Property)new IntegerProperty())).name("limit")).required(true);
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenParameter cm = codegen.fromParameter((Parameter)parameter, null);
        Assert.assertNull((Object)cm.allowableValues);
    }

    @DataProvider(name="modelNames")
    public static Object[][] primeNumbers() {
        return new Object[][]{{"sample", "Sample"}, {"sample_name", "SampleName"}, {"sample__name", "SampleName"}, {"/sample", "Sample"}, {"\\sample", "Sample"}, {"sample.name", "SampleName"}, {"_sample", "Sample"}, {"Sample", "Sample"}};
    }

    @Test(dataProvider="modelNames", description="avoid inner class")
    public void modelNameTest(String name, String expectedName) {
        ModelImpl model = new ModelImpl();
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel(name, (Model)model);
        Assert.assertEquals((String)cm.name, (String)name);
        Assert.assertEquals((String)cm.classname, (String)expectedName);
    }
}

