/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.javascript;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavascriptClientCodegen;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavaScriptModelEnumTest {
    @Test(description="convert a JavaScript model with an enum")
    public void converterTest() {
        StringProperty enumProperty = new StringProperty();
        enumProperty.setEnum(Arrays.asList("VALUE1", "VALUE2", "VALUE3"));
        ModelImpl model = new ModelImpl().property("name", (Property)enumProperty);
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty enumVar = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)enumVar.baseName, (String)"name");
        Assert.assertEquals((String)enumVar.datatype, (String)"String");
        Assert.assertEquals((String)enumVar.datatypeWithEnum, (String)"NameEnum");
        Assert.assertEquals((String)enumVar.name, (String)"name");
        Assert.assertEquals((String)enumVar.defaultValue, null);
        Assert.assertEquals((String)enumVar.baseType, (String)"String");
        Assert.assertTrue((boolean)enumVar.isEnum);
    }

    @Test(description="not override identical parent enums")
    public void overrideEnumTest() {
        StringProperty identicalEnumProperty = new StringProperty();
        identicalEnumProperty.setEnum(Arrays.asList("VALUE1", "VALUE2", "VALUE3"));
        StringProperty subEnumProperty = new StringProperty();
        subEnumProperty.setEnum(Arrays.asList("SUB1", "SUB2", "SUB3"));
        HashMap<String, StringProperty> parentProperties = new HashMap<String, StringProperty>();
        parentProperties.put("sharedThing", identicalEnumProperty);
        HashMap<String, StringProperty> subProperties = new HashMap<String, StringProperty>();
        subProperties.put("sharedThing", identicalEnumProperty);
        subProperties.put("unsharedThing", identicalEnumProperty);
        ModelImpl parentModel = new ModelImpl();
        parentModel.setProperties(parentProperties);
        parentModel.name("parentModel");
        ModelImpl subModel = new ModelImpl();
        subModel.setProperties(subProperties);
        subModel.name("subModel");
        ComposedModel model = new ComposedModel().parent((Model)new RefModel(parentModel.getName())).child((Model)subModel).interfaces(new ArrayList());
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        HashMap<String, ModelImpl> allModels = new HashMap<String, ModelImpl>();
        allModels.put(parentModel.getName(), parentModel);
        allModels.put(subModel.getName(), subModel);
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allModels);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"ParentModel");
        Assert.assertTrue((boolean)cm.imports.contains("ParentModel"));
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty enumVar = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)enumVar.baseName, (String)"unsharedThing");
        Assert.assertEquals((String)enumVar.datatype, (String)"String");
        Assert.assertEquals((String)enumVar.datatypeWithEnum, (String)"UnsharedThingEnum");
        Assert.assertTrue((boolean)enumVar.isEnum);
    }

    @Test(description="test enum array model")
    public void enumArrayModelTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        Model definition = (Model)model.getDefinitions().get("EnumArrays");
        Property property = (Property)definition.getProperties().get("array_enum");
        CodegenProperty prope = codegen.fromProperty("array_enum", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"[ArrayEnumEnum]");
        Assert.assertEquals((String)prope.enumName, (String)"ArrayEnumEnum");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        HashMap<String, String> fish = new HashMap<String, String>();
        fish.put("name", "fish");
        fish.put("value", "\"fish\"");
        HashMap<String, String> crab = new HashMap<String, String>();
        crab.put("name", "crab");
        crab.put("value", "\"crab\"");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"[ArrayEnumEnum]");
        Assert.assertEquals((String)prope.enumName, (String)"ArrayEnumEnum");
        Assert.assertTrue((boolean)prope.items.isEnum);
        Assert.assertEquals(prope.items.allowableValues.get("values"), Arrays.asList("fish", "crab"));
        Assert.assertEquals(prope.items.allowableValues.get("enumVars"), Arrays.asList(fish, crab));
    }

    @Test(description="test enum model for values (numeric, string, etc)")
    public void enumModelValueTest() {
        Swagger model = new SwaggerParser().read("src/test/resources/2_0/petstore-with-fake-endpoints-models-for-testing.yaml");
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        Model definition = (Model)model.getDefinitions().get("Enum_Test");
        Property property = (Property)definition.getProperties().get("enum_integer");
        CodegenProperty prope = codegen.fromProperty("enum_integer", property);
        codegen.updateCodegenPropertyEnum(prope);
        Assert.assertEquals((String)prope.datatypeWithEnum, (String)"EnumIntegerEnum");
        Assert.assertEquals((String)prope.enumName, (String)"EnumIntegerEnum");
        Assert.assertTrue((boolean)prope.isEnum);
        Assert.assertFalse((boolean)prope.isContainer);
        Assert.assertNull((Object)prope.items);
        Assert.assertEquals(prope.allowableValues.get("values"), Arrays.asList(1, -1));
        HashMap<String, String> one = new HashMap<String, String>();
        one.put("name", "_1");
        one.put("value", "1");
        HashMap<String, String> minusOne = new HashMap<String, String>();
        minusOne.put("name", "_1_2");
        minusOne.put("value", "-1");
        Assert.assertEquals(prope.allowableValues.get("enumVars"), Arrays.asList(one, minusOne));
    }
}

