/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.javascript;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavascriptClientCodegen;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavaScriptInheritanceTest {
    @Test(description="convert a composed model with inheritance enabled")
    public void javascriptInheritanceTest() {
        ModelImpl base = new ModelImpl();
        base.addProperty("baseProp", (Property)new StringProperty().required(true));
        ModelImpl intf1 = new ModelImpl();
        intf1.addProperty("intf1Prop", (Property)new StringProperty());
        ModelImpl intf2 = new ModelImpl();
        intf2.addProperty("intf2Prop", (Property)new StringProperty().required(true));
        ModelImpl child = new ModelImpl();
        child.addProperty("childProp", (Property)new StringProperty().required(true));
        HashMap<String, ModelImpl> allDefinitions = new HashMap<String, ModelImpl>();
        allDefinitions.put("Base", base);
        allDefinitions.put("Interface1", intf1);
        allDefinitions.put("Interface2", intf2);
        ComposedModel model = new ComposedModel().parent((Model)new RefModel("Base")).interfaces(Arrays.asList(new RefModel("Interface1"), new RefModel("Interface2"))).child((Model)child);
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        codegen.setUseInheritance(true);
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allDefinitions);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"Base");
        Assert.assertEquals((Collection)cm.interfaces, Arrays.asList("Interface1", "Interface2"));
        Assert.assertEquals((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Base", "Interface1", "Interface2"}));
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((String)((CodegenProperty)cm.vars.get((int)0)).name, (String)"childProp");
        Assert.assertEquals((int)cm.allVars.size(), (int)4);
        String[] allVars = new String[]{"intf1Prop", "intf2Prop", "baseProp", "childProp"};
        for (int i = 0; i < allVars.length; ++i) {
            Assert.assertEquals((String)((CodegenProperty)cm.allVars.get((int)i)).name, (String)allVars[i]);
        }
        Assert.assertEquals((Set)cm.mandatory, (Set)Sets.newHashSet((Object[])new String[]{"childProp"}));
        Assert.assertEquals((Set)cm.allMandatory, (Set)Sets.newHashSet((Object[])new String[]{"baseProp", "intf2Prop", "childProp"}));
    }

    @Test(description="convert a composed model with inheritance disabled")
    public void javascriptNoInheritanceTest() {
        ModelImpl base = new ModelImpl();
        base.addProperty("baseProp", (Property)new StringProperty().required(true));
        ModelImpl intf1 = new ModelImpl();
        intf1.addProperty("intf1Prop", (Property)new StringProperty());
        ModelImpl intf2 = new ModelImpl();
        intf2.addProperty("intf2Prop", (Property)new StringProperty().required(true));
        ModelImpl child = new ModelImpl();
        child.addProperty("childProp", (Property)new StringProperty().required(true));
        HashMap<String, ModelImpl> allDefinitions = new HashMap<String, ModelImpl>();
        allDefinitions.put("Base", base);
        allDefinitions.put("Interface1", intf1);
        allDefinitions.put("Interface2", intf2);
        ComposedModel model = new ComposedModel().parent((Model)new RefModel("Base")).interfaces(Arrays.asList(new RefModel("Interface1"), new RefModel("Interface2"))).child((Model)child);
        JavascriptClientCodegen codegen = new JavascriptClientCodegen();
        codegen.setUseInheritance(false);
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allDefinitions);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"Base");
        Assert.assertEquals((Collection)cm.interfaces, Arrays.asList("Interface1", "Interface2"));
        Assert.assertEquals((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Base", "Interface1", "Interface2"}));
        Assert.assertEquals((int)cm.vars.size(), (int)4);
        Assert.assertEquals((int)cm.allVars.size(), (int)4);
        String[] allVars = new String[]{"intf1Prop", "intf2Prop", "baseProp", "childProp"};
        for (int i = 0; i < allVars.length; ++i) {
            Assert.assertEquals((String)((CodegenProperty)cm.vars.get((int)i)).name, (String)allVars[i]);
            Assert.assertEquals((String)((CodegenProperty)cm.allVars.get((int)i)).name, (String)allVars[i]);
        }
        Assert.assertEquals((Set)cm.mandatory, (Set)Sets.newHashSet((Object[])new String[]{"baseProp", "intf2Prop", "childProp"}));
        Assert.assertEquals((Set)cm.allMandatory, (Set)Sets.newHashSet((Object[])new String[]{"baseProp", "intf2Prop", "childProp"}));
    }
}

