/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.java.jaxrs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CodegenParameter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AllowableValuesTest {
    private static final String TEMPLATE_FILE = "JavaJaxRS/allowableValues.mustache";
    private static final String PROVIDER_NAME = "operations";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadClassResource(Class<?> cls, String name) throws IOException {
        String string;
        InputStream in = null;
        try {
            in = cls.getClassLoader().getResourceAsStream(name);
            string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    @DataProvider(name="operations")
    private static Object[][] resource() {
        CodegenParameter param1 = new CodegenParameter();
        CodegenParameter param2 = new CodegenParameter(){
            {
                this.allowableValues = ImmutableMap.of((Object)"values", (Object)ImmutableList.of((Object)"item1", (Object)"item2", (Object)"item3"));
            }
        };
        CodegenParameter param3 = new CodegenParameter(){
            {
                this.allowableValues = ImmutableMap.of((Object)"min", (Object)1, (Object)"max", (Object)10);
            }
        };
        CodegenParameter param4 = new CodegenParameter(){
            {
                this.allowableValues = ImmutableMap.of((Object)"min", (Object)1);
            }
        };
        CodegenParameter param5 = new CodegenParameter(){
            {
                this.allowableValues = ImmutableMap.of((Object)"max", (Object)10);
            }
        };
        return new Object[][]{{param1, ""}, {param2, "allowableValues=\"item1, item2, item3\""}, {param3, "allowableValues=\"range=[1, 10]\""}, {param4, "allowableValues=\"range=[1, infinity]\""}, {param5, "allowableValues=\"range=[-infinity, 10]\""}};
    }

    @Test(dataProvider="operations")
    public void annotationsTest(CodegenParameter parameter, String expected) throws IOException {
        Template template = Mustache.compiler().compile(AllowableValuesTest.loadClassResource(this.getClass(), TEMPLATE_FILE));
        Assert.assertEquals((String)template.execute((Object)parameter), (String)expected);
    }
}

