/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.java;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JavaModelTest {
    @Test(description="convert a simple java model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty().example("Tony")).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        List vars = cm.vars;
        CodegenProperty property1 = (CodegenProperty)vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.getter, (String)"getId");
        Assert.assertEquals((String)property1.setter, (String)"setId");
        Assert.assertEquals((String)property1.datatype, (String)"Long");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"Long");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.getter, (String)"getName");
        Assert.assertEquals((String)property2.setter, (String)"setName");
        Assert.assertEquals((String)property2.datatype, (String)"String");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"String");
        Assert.assertEquals((String)property2.example, (String)"Tony");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property3.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property3.datatype, (String)"Date");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"Date");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"urls");
        Assert.assertEquals((String)property.getter, (String)"getUrls");
        Assert.assertEquals((String)property.setter, (String)"setUrls");
        Assert.assertEquals((String)property.datatype, (String)"List<String>");
        Assert.assertEquals((String)property.name, (String)"urls");
        Assert.assertEquals((String)property.defaultValue, (String)"new ArrayList<String>()");
        Assert.assertEquals((String)property.baseType, (String)"List");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"translations");
        Assert.assertEquals((String)property.getter, (String)"getTranslations");
        Assert.assertEquals((String)property.setter, (String)"setTranslations");
        Assert.assertEquals((String)property.datatype, (String)"Map<String, String>");
        Assert.assertEquals((String)property.name, (String)"translations");
        Assert.assertEquals((String)property.defaultValue, (String)"new HashMap<String, String>()");
        Assert.assertEquals((String)property.baseType, (String)"Map");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a map with complex list property")
    public void mapWithListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new ArrayProperty().items((Property)new RefProperty("Pet")))).required("id");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"translations");
        Assert.assertEquals((String)property.getter, (String)"getTranslations");
        Assert.assertEquals((String)property.setter, (String)"setTranslations");
        Assert.assertEquals((String)property.datatype, (String)"Map<String, List<Pet>>");
        Assert.assertEquals((String)property.name, (String)"translations");
        Assert.assertEquals((String)property.defaultValue, (String)"new HashMap<String, List<Pet>>()");
        Assert.assertEquals((String)property.baseType, (String)"Map");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with a 2D list property")
    public void list2DPropertyTest() {
        ModelImpl model = new ModelImpl().name("sample").property("list2D", (Property)new ArrayProperty().items((Property)new ArrayProperty().items((Property)new RefProperty("Pet"))));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"list2D");
        Assert.assertEquals((String)property.getter, (String)"getList2D");
        Assert.assertEquals((String)property.setter, (String)"setList2D");
        Assert.assertEquals((String)property.datatype, (String)"List<List<Pet>>");
        Assert.assertEquals((String)property.name, (String)"list2D");
        Assert.assertEquals((String)property.defaultValue, (String)"new ArrayList<List<Pet>>()");
        Assert.assertEquals((String)property.baseType, (String)"List");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with complex properties")
    public void complexPropertiesTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"Children");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"Children");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.complexType, (String)"Children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"List<Children>");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, (String)"new ArrayList<Children>()");
        Assert.assertEquals((String)property.baseType, (String)"List");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Map", "List", "Children"})).size(), (int)3);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.complexType, (String)"Children");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"Map<String, Children>");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, (String)"new HashMap<String, Children>()");
        Assert.assertEquals((String)property.baseType, (String)"Map");
        Assert.assertEquals((String)property.containerType, (String)"map");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
        Assert.assertFalse((boolean)property.isNotContainer);
    }

    @Test(description="convert a model with an array property with item name")
    public void arrayModelWithItemNameTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().description("an array property").items((Property)new RefProperty("#/definitions/Child")).vendorExtension("x-item-name", (Object)"child"));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"List", "Child"})).size(), (int)2);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"children");
        Assert.assertEquals((String)property.complexType, (String)"Child");
        Assert.assertEquals((String)property.getter, (String)"getChildren");
        Assert.assertEquals((String)property.setter, (String)"setChildren");
        Assert.assertEquals((String)property.datatype, (String)"List<Child>");
        Assert.assertEquals((String)property.name, (String)"children");
        Assert.assertEquals((String)property.defaultValue, (String)"new ArrayList<Child>()");
        Assert.assertEquals((String)property.baseType, (String)"List");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
        Assert.assertFalse((boolean)property.isNotContainer);
        CodegenProperty itemsProperty = property.items;
        Assert.assertEquals((String)itemsProperty.baseName, (String)"child");
        Assert.assertEquals((String)itemsProperty.name, (String)"child");
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"ArrayList<Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"ApiModel", "List", "ArrayList", "Children"})).size(), (int)4);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("an map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"HashMap<String, Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"ApiModel", "Map", "HashMap", "Children"})).size(), (int)4);
    }

    @Test(description="convert a model with upper-case property names")
    public void upperCaseNamesTest() {
        ModelImpl model = new ModelImpl().description("a model with upper-case property names").property("NAME", (Property)new StringProperty()).required("NAME");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"NAME");
        Assert.assertEquals((String)property.getter, (String)"getNAME");
        Assert.assertEquals((String)property.setter, (String)"setNAME");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"NAME");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a model with a 2nd char upper-case property names")
    public void secondCharUpperCaseNamesTest() {
        ModelImpl model = new ModelImpl().description("a model with a 2nd char upper-case property names").property("pId", (Property)new StringProperty()).required("pId");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"pId");
        Assert.assertEquals((String)property.getter, (String)"getPId");
        Assert.assertEquals((String)property.setter, (String)"setPId");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"pId");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a model starting with two upper-case letter property names")
    public void firstTwoUpperCaseLetterNamesTest() {
        ModelImpl model = new ModelImpl().description("a model with a property name starting with two upper-case letters").property("ATTName", (Property)new StringProperty()).required("ATTName");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"ATTName");
        Assert.assertEquals((String)property.getter, (String)"getAtTName");
        Assert.assertEquals((String)property.setter, (String)"setAtTName");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"atTName");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert hyphens per issue 503")
    public void hyphensTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("created-at", (Property)new DateTimeProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"created-at");
        Assert.assertEquals((String)property.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property.name, (String)"createdAt");
    }

    @Test(description="convert query[password] to queryPassword")
    public void squareBracketsTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("query[password]", (Property)new StringProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"query[password]");
        Assert.assertEquals((String)property.getter, (String)"getQueryPassword");
        Assert.assertEquals((String)property.setter, (String)"setQueryPassword");
        Assert.assertEquals((String)property.name, (String)"queryPassword");
    }

    @Test(description="properly escape names per 567")
    public void escapeNamesTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("created-at", (Property)new DateTimeProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("with.dots", (Model)model);
        Assert.assertEquals((String)cm.classname, (String)"WithDots");
    }

    @Test(description="convert a model with binary data")
    public void binaryDataTest() {
        ModelImpl model = new ModelImpl().description("model with binary").property("inputBinaryData", (Property)new ByteArrayProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"inputBinaryData");
        Assert.assertEquals((String)property.getter, (String)"getInputBinaryData");
        Assert.assertEquals((String)property.setter, (String)"setInputBinaryData");
        Assert.assertEquals((String)property.datatype, (String)"byte[]");
        Assert.assertEquals((String)property.name, (String)"inputBinaryData");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"byte[]");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="translate an invalid param name")
    public void invalidParamNameTest() {
        ModelImpl model = new ModelImpl().description("a model with a 2nd char upper-case property names").property("_", (Property)new StringProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)"_");
        Assert.assertEquals((String)property.getter, (String)"getU");
        Assert.assertEquals((String)property.setter, (String)"setU");
        Assert.assertEquals((String)property.datatype, (String)"String");
        Assert.assertEquals((String)property.name, (String)"u");
        Assert.assertEquals((String)property.defaultValue, (String)"null");
        Assert.assertEquals((String)property.baseType, (String)"String");
        Assert.assertFalse((boolean)property.hasMore);
        Assert.assertTrue((boolean)property.isNotContainer);
    }

    @Test(description="convert a parameter")
    public void convertParameterTest() {
        QueryParameter parameter = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().property((Property)new IntegerProperty())).name("limit")).required(true);
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenParameter cm = codegen.fromParameter((Parameter)parameter, null);
        Assert.assertNull((Object)cm.allowableValues);
    }

    @Test(description="types used by inner properties should be imported")
    public void mapWithAnListOfBigDecimalTest() {
        CodegenModel cm1 = new JavaClientCodegen().fromModel("sample", (Model)new ModelImpl().description("model with Map<String, List<BigDecimal>>").property("map", (Property)new MapProperty().additionalProperties((Property)new ArrayProperty((Property)new DecimalProperty()))));
        Assert.assertEquals((String)((CodegenProperty)cm1.vars.get((int)0)).datatype, (String)"Map<String, List<BigDecimal>>");
        Assert.assertTrue((boolean)cm1.imports.contains("BigDecimal"));
        CodegenModel cm2 = new JavaClientCodegen().fromModel("sample", (Model)new ModelImpl().description("model with Map<String, Map<String, List<BigDecimal>>>").property("map", (Property)new MapProperty().additionalProperties((Property)new MapProperty().additionalProperties((Property)new ArrayProperty((Property)new DecimalProperty())))));
        Assert.assertEquals((String)((CodegenProperty)cm2.vars.get((int)0)).datatype, (String)"Map<String, Map<String, List<BigDecimal>>>");
        Assert.assertTrue((boolean)cm2.imports.contains("BigDecimal"));
    }

    @DataProvider(name="modelNames")
    public static Object[][] primeNumbers() {
        return new Object[][]{{"sample", "Sample"}, {"sample_name", "SampleName"}, {"sample__name", "SampleName"}, {"/sample", "Sample"}, {"\\sample", "Sample"}, {"sample.name", "SampleName"}, {"_sample", "Sample"}, {"Sample", "Sample"}};
    }

    @Test(dataProvider="modelNames", description="avoid inner class")
    public void modelNameTest(String name, String expectedName) {
        ModelImpl model = new ModelImpl();
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel(name, (Model)model);
        Assert.assertEquals((String)cm.name, (String)name);
        Assert.assertEquals((String)cm.classname, (String)expectedName);
    }

    @DataProvider(name="classProperties")
    public static Object[][] classProperties() {
        return new Object[][]{{"class", "getPropertyClass", "setPropertyClass", "propertyClass"}, {"_class", "getPropertyClass", "setPropertyClass", "propertyClass"}, {"__class", "getPropertyClass", "setPropertyClass", "propertyClass"}};
    }

    @Test(dataProvider="classProperties", description="handle 'class' properties")
    public void classPropertyTest(String baseName, String getter, String setter, String name) {
        ModelImpl model = new ModelImpl().description("a sample model").property(baseName, (Property)new StringProperty());
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        CodegenProperty property = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property.baseName, (String)baseName);
        Assert.assertEquals((String)property.getter, (String)getter);
        Assert.assertEquals((String)property.setter, (String)setter);
        Assert.assertEquals((String)property.name, (String)name);
    }

    @Test(description="test models with xml")
    public void modelWithXmlTest() {
        ModelImpl model = new ModelImpl().description("a sample model").xml(new Xml().prefix("my").namespace("xmlNamespace").name("customXmlName")).property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty().example("Tony").xml(new Xml().attribute(Boolean.valueOf(true)).prefix("my").name("myName"))).property("createdAt", (Property)new DateTimeProperty().xml(new Xml().prefix("my").namespace("myNamespace").name("myCreatedAt"))).required("id").required("name");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((String)cm.xmlPrefix, (String)"my");
        Assert.assertEquals((String)cm.xmlName, (String)"customXmlName");
        Assert.assertEquals((String)cm.xmlNamespace, (String)"xmlNamespace");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        List vars = cm.vars;
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.getter, (String)"getName");
        Assert.assertEquals((String)property2.setter, (String)"setName");
        Assert.assertEquals((String)property2.datatype, (String)"String");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property2.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"String");
        Assert.assertEquals((String)property2.example, (String)"Tony");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isNotContainer);
        Assert.assertTrue((boolean)property2.isXmlAttribute);
        Assert.assertEquals((String)property2.xmlName, (String)"myName");
        Assert.assertNull((Object)property2.xmlNamespace);
        CodegenProperty property3 = (CodegenProperty)vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.getter, (String)"getCreatedAt");
        Assert.assertEquals((String)property3.setter, (String)"setCreatedAt");
        Assert.assertEquals((String)property3.datatype, (String)"Date");
        Assert.assertEquals((String)property3.name, (String)"createdAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"Date");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
        Assert.assertFalse((boolean)property3.isXmlAttribute);
        Assert.assertEquals((String)property3.xmlName, (String)"myCreatedAt");
        Assert.assertEquals((String)property3.xmlNamespace, (String)"myNamespace");
        Assert.assertEquals((String)property3.xmlPrefix, (String)"my");
    }

    @Test(description="test models with wrapped xml")
    public void modelWithWrappedXmlTest() {
        ModelImpl model = new ModelImpl().description("a sample model").xml(new Xml().prefix("my").namespace("xmlNamespace").name("customXmlName")).property("id", (Property)new LongProperty()).property("array", (Property)new ArrayProperty().xml(new Xml().prefix("my").wrapped(Boolean.valueOf(true)).namespace("myNamespace").name("xmlArray")).items((Property)new StringProperty().xml(new Xml().name("i")))).required("id");
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((String)cm.xmlPrefix, (String)"my");
        Assert.assertEquals((String)cm.xmlName, (String)"customXmlName");
        Assert.assertEquals((String)cm.xmlNamespace, (String)"xmlNamespace");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        List vars = cm.vars;
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"array");
        Assert.assertEquals((String)property2.getter, (String)"getArray");
        Assert.assertEquals((String)property2.setter, (String)"setArray");
        Assert.assertEquals((String)property2.datatype, (String)"List<String>");
        Assert.assertEquals((String)property2.name, (String)"array");
        Assert.assertEquals((String)property2.defaultValue, (String)"new ArrayList<String>()");
        Assert.assertEquals((String)property2.baseType, (String)"List");
        Assert.assertTrue((boolean)property2.isContainer);
        Assert.assertTrue((boolean)property2.isXmlWrapped);
        Assert.assertEquals((String)property2.xmlName, (String)"xmlArray");
        Assert.assertNotNull((Object)property2.xmlNamespace);
        Assert.assertNotNull((Object)property2.items);
        CodegenProperty items = property2.items;
        Assert.assertEquals((String)items.xmlName, (String)"i");
        Assert.assertEquals((String)items.baseName, (String)"array");
    }

    @Test(description="convert a boolean parameter")
    public void booleanParameterTest() {
        BooleanProperty property = new BooleanProperty();
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenProperty cp = codegen.fromProperty("property", (Property)property);
        Assert.assertEquals((String)cp.baseName, (String)"property");
        Assert.assertEquals((String)cp.datatype, (String)"Boolean");
        Assert.assertEquals((String)cp.name, (String)"property");
        Assert.assertEquals((String)cp.baseType, (String)"Boolean");
        Assert.assertTrue((boolean)cp.isNotContainer);
        Assert.assertTrue((boolean)cp.isBoolean);
        Assert.assertEquals((String)cp.getter, (String)"Property");
    }
}

