/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.java;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavaModelEnumTest {
    @Test(description="convert a java model with an enum")
    public void converterTest() {
        StringProperty enumProperty = new StringProperty();
        enumProperty.setEnum(Arrays.asList("VALUE1", "VALUE2", "VALUE3"));
        ModelImpl model = new ModelImpl().property("name", (Property)enumProperty);
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty enumVar = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)enumVar.baseName, (String)"name");
        Assert.assertEquals((String)enumVar.datatype, (String)"String");
        Assert.assertEquals((String)enumVar.datatypeWithEnum, (String)"NameEnum");
        Assert.assertEquals((String)enumVar.name, (String)"name");
        Assert.assertEquals((String)enumVar.defaultValue, (String)"null");
        Assert.assertEquals((String)enumVar.baseType, (String)"String");
        Assert.assertTrue((boolean)enumVar.isEnum);
    }

    @Test(description="not override identical parent enums")
    public void overrideEnumTest() {
        StringProperty identicalEnumProperty = new StringProperty();
        identicalEnumProperty.setEnum(Arrays.asList("VALUE1", "VALUE2", "VALUE3"));
        StringProperty subEnumProperty = new StringProperty();
        subEnumProperty.setEnum(Arrays.asList("SUB1", "SUB2", "SUB3"));
        HashMap<String, StringProperty> parentProperties = new HashMap<String, StringProperty>();
        parentProperties.put("sharedThing", identicalEnumProperty);
        HashMap<String, StringProperty> subProperties = new HashMap<String, StringProperty>();
        subProperties.put("sharedThing", identicalEnumProperty);
        subProperties.put("unsharedThing", identicalEnumProperty);
        ModelImpl parentModel = new ModelImpl();
        parentModel.setProperties(parentProperties);
        parentModel.name("parentModel");
        ModelImpl subModel = new ModelImpl();
        subModel.setProperties(subProperties);
        subModel.name("subModel");
        ComposedModel model = new ComposedModel().parent((Model)new RefModel(parentModel.getName())).child((Model)subModel).interfaces(new ArrayList());
        JavaClientCodegen codegen = new JavaClientCodegen();
        HashMap<String, ModelImpl> allModels = new HashMap<String, ModelImpl>();
        allModels.put(parentModel.getName(), parentModel);
        allModels.put(subModel.getName(), subModel);
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allModels);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"ParentModel");
        Assert.assertTrue((boolean)cm.imports.contains("ParentModel"));
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty enumVar = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)enumVar.baseName, (String)"unsharedThing");
        Assert.assertEquals((String)enumVar.datatype, (String)"String");
        Assert.assertEquals((String)enumVar.datatypeWithEnum, (String)"UnsharedThingEnum");
        Assert.assertTrue((boolean)enumVar.isEnum);
    }

    @Test(description="not override identical parent enums")
    public void testEnumTypes() {
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        Swagger swagger = new SwaggerParser().read("2_0/issue-10546.yaml", null, true);
        Model booleanModel = (Model)swagger.getDefinitions().get("Boolean");
        CodegenModel codegenModel = codegenConfig.fromModel("Boolean", booleanModel);
        Assert.assertTrue((boolean)codegenModel.isEnum);
        Assert.assertEquals((String)codegenModel.dataType, (String)"Boolean");
    }
}

