/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.java;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JavaInheritanceTest {
    @Test(description="convert a composed model with parent")
    public void javaInheritanceTest() {
        ComposedModel model = new ComposedModel().parent((Model)new RefModel("Base")).child((Model)new ModelImpl().additionalProperties((Property)new StringProperty()));
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"Base");
        Assert.assertEquals((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Base"}));
    }

    @Test(description="convert a composed model with discriminator")
    public void javaInheritanceWithDiscriminatorTest() {
        ModelImpl base = new ModelImpl();
        base.setDiscriminator("disc");
        ComposedModel model = new ComposedModel().interfaces(Arrays.asList(new RefModel("Base"))).child((Model)new ModelImpl().additionalProperties((Property)new StringProperty()));
        HashMap<String, ModelImpl> allDefinitions = new HashMap<String, ModelImpl>();
        allDefinitions.put("Base", base);
        JavaClientCodegen codegen = new JavaClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allDefinitions);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"Base");
        Assert.assertEquals((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Base"}));
    }
}

