/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.java;

import io.swagger.codegen.CodegenType;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractJavaCodegenTest {
    private final AbstractJavaCodegen fakeJavaCodegen = new P_AbstractJavaCodegen();

    @Test
    public void toEnumVarNameShouldNotShortenUnderScore() throws Exception {
        Assert.assertEquals((String)"UNDERSCORE", (String)this.fakeJavaCodegen.toEnumVarName("_", "String"));
        Assert.assertEquals((String)"__", (String)this.fakeJavaCodegen.toEnumVarName("__", "String"));
        Assert.assertEquals((String)"__", (String)this.fakeJavaCodegen.toEnumVarName("_,.", "String"));
    }

    @Test
    public void toVarNameShouldAvoidOverloadingGetClassMethod() throws Exception {
        Assert.assertEquals((String)"propertyClass", (String)this.fakeJavaCodegen.toVarName("class"));
        Assert.assertEquals((String)"propertyClass", (String)this.fakeJavaCodegen.toVarName("_class"));
        Assert.assertEquals((String)"propertyClass", (String)this.fakeJavaCodegen.toVarName("__class"));
    }

    @Test
    public void toModelNameShouldUseProvidedMapping() throws Exception {
        this.fakeJavaCodegen.importMapping().put("json_myclass", "com.test.MyClass");
        Assert.assertEquals((String)"com.test.MyClass", (String)this.fakeJavaCodegen.toModelName("json_myclass"));
    }

    @Test
    public void toModelNameUsesPascalCase() throws Exception {
        Assert.assertEquals((String)"JsonAnotherclass", (String)this.fakeJavaCodegen.toModelName("json_anotherclass"));
    }

    @Test
    public void preprocessSwaggerWithFormParamsSetsContentType() {
        Path dummyPath = new Path().post(new Operation().parameter((Parameter)new FormParameter())).get(new Operation());
        Swagger swagger = new Swagger().path("dummy", dummyPath);
        this.fakeJavaCodegen.preprocessSwagger(swagger);
        Assert.assertNull(swagger.getPath("dummy").getGet().getVendorExtensions().get("x-contentType"));
        Assert.assertEquals(swagger.getPath("dummy").getPost().getVendorExtensions().get("x-contentType"), (Object)"application/x-www-form-urlencoded");
    }

    @Test
    public void preprocessSwaggerWithBodyParamsSetsContentType() {
        Path dummyPath = new Path().post(new Operation().parameter((Parameter)new BodyParameter())).get(new Operation());
        Swagger swagger = new Swagger().path("dummy", dummyPath);
        this.fakeJavaCodegen.preprocessSwagger(swagger);
        Assert.assertNull(swagger.getPath("dummy").getGet().getVendorExtensions().get("x-contentType"));
        Assert.assertEquals(swagger.getPath("dummy").getPost().getVendorExtensions().get("x-contentType"), (Object)"application/json");
    }

    @Test
    public void preprocessSwaggerWithNoFormOrBodyParamsDoesNotSetContentType() {
        Path dummyPath = new Path().post(new Operation()).get(new Operation());
        Swagger swagger = new Swagger().path("dummy", dummyPath);
        this.fakeJavaCodegen.preprocessSwagger(swagger);
        Assert.assertNull(swagger.getPath("dummy").getGet().getVendorExtensions().get("x-contentType"));
        Assert.assertNull(swagger.getPath("dummy").getPost().getVendorExtensions().get("x-contentType"));
    }

    @Test
    public void testInitialConfigValues() throws Exception {
        P_AbstractJavaCodegen codegen = new P_AbstractJavaCodegen();
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"invalidPackageName");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"invalidPackageName");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"invalidPackageName");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"invalidPackageName");
        Assert.assertEquals((String)codegen.getInvokerPackage(), (String)"io.swagger");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"io.swagger");
    }

    @Test
    public void testSettersForConfigValues() throws Exception {
        P_AbstractJavaCodegen codegen = new P_AbstractJavaCodegen();
        codegen.setHideGenerationTimestamp(true);
        codegen.setModelPackage("xyz.yyyyy.zzzzzzz.model");
        codegen.setApiPackage("xyz.yyyyy.zzzzzzz.api");
        codegen.setInvokerPackage("xyz.yyyyy.zzzzzzz.invoker");
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.TRUE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)true);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.zzzzzzz.model");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.zzzzzzz.model");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"xyz.yyyyy.zzzzzzz.api");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"xyz.yyyyy.zzzzzzz.api");
        Assert.assertEquals((String)codegen.getInvokerPackage(), (String)"xyz.yyyyy.zzzzzzz.invoker");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.zzzzzzz.invoker");
    }

    @Test
    public void testAdditionalPropertiesPutForConfigValues() throws Exception {
        P_AbstractJavaCodegen codegen = new P_AbstractJavaCodegen();
        codegen.additionalProperties().put("hideGenerationTimestamp", false);
        codegen.additionalProperties().put("modelPackage", "xyz.yyyyy.model.oooooo");
        codegen.additionalProperties().put("apiPackage", "xyz.yyyyy.api.oooooo");
        codegen.additionalProperties().put("invokerPackage", "xyz.yyyyy.invoker.oooooo");
        codegen.processOpts();
        Assert.assertEquals(codegen.additionalProperties().get("hideGenerationTimestamp"), (Object)Boolean.FALSE);
        Assert.assertEquals((boolean)codegen.isHideGenerationTimestamp(), (boolean)false);
        Assert.assertEquals((String)codegen.modelPackage(), (String)"xyz.yyyyy.model.oooooo");
        Assert.assertEquals(codegen.additionalProperties().get("modelPackage"), (Object)"xyz.yyyyy.model.oooooo");
        Assert.assertEquals((String)codegen.apiPackage(), (String)"xyz.yyyyy.api.oooooo");
        Assert.assertEquals(codegen.additionalProperties().get("apiPackage"), (Object)"xyz.yyyyy.api.oooooo");
        Assert.assertEquals((String)codegen.getInvokerPackage(), (String)"xyz.yyyyy.invoker.oooooo");
        Assert.assertEquals(codegen.additionalProperties().get("invokerPackage"), (Object)"xyz.yyyyy.invoker.oooooo");
    }

    private static class P_AbstractJavaCodegen
    extends AbstractJavaCodegen {
        private P_AbstractJavaCodegen() {
        }

        public CodegenType getTag() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getHelp() {
            return null;
        }
    }
}

