/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.ignore.rules;

import io.swagger.codegen.ignore.rules.IgnoreLineParser;
import io.swagger.codegen.ignore.rules.Part;
import io.swagger.codegen.ignore.rules.RootedFileRule;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RootedFileRuleTest {
    @Test
    public void testMatchFilenameOnly() throws Exception {
        String definition = "/foo";
        String relativePath = "foo";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo");
        Boolean actual = null;
        actual = rule.matches("foo");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchFilenameOnly() throws Exception {
        String definition = "/foo";
        String relativePath = "bar";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo");
        Boolean actual = null;
        actual = rule.matches("bar");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testMatchFilenameAndExtension() throws Exception {
        String definition = "/foo.txt";
        String relativePath = "foo.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo.txt");
        Boolean actual = null;
        actual = rule.matches("foo.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchFilenameAndExtension() throws Exception {
        String definition = "/foo.txt";
        String relativePath = "bar.baz";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo.txt");
        Boolean actual = null;
        actual = rule.matches("bar.baz");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testMatchFilenameWithGlob() throws Exception {
        String definition = "/foo*";
        String relativePath = "foobarbaz";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*");
        Boolean actual = null;
        actual = rule.matches("foobarbaz");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchFilenameWithGlob() throws Exception {
        String definition = "/foo*";
        String relativePath = "boobarbaz";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*");
        Boolean actual = null;
        actual = rule.matches("boobarbaz");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testMatchFilenameAndExtensionWithFilenameGlob() throws Exception {
        String definition = "/foo*.txt";
        String relativePath = "foobarbaz.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*.txt");
        Boolean actual = null;
        actual = rule.matches("foobarbaz.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchFilenameAndExtensionWithFilenameGlob() throws Exception {
        String definition = "/foo*qux.txt";
        String relativePath = "foobarbaz.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, "qux.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*qux.txt");
        Boolean actual = null;
        actual = rule.matches("foobarbaz.txt");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testMatchFilenameAndExtensionWithExtensionGlob() throws Exception {
        String definition = "/foo.*";
        String relativePath = "foo.bak";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo."), new Part(IgnoreLineParser.Token.MATCH_ANY));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo.*");
        Boolean actual = null;
        actual = rule.matches("foo.bak");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testMatchFilenameAndExtensionWithMultiplePeriods() throws Exception {
        String definition = "/foo*.xyzzy.txt";
        String relativePath = "foo.bar.baz.xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".xyzzy.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*.xyzzy.txt");
        Boolean actual = null;
        actual = rule.matches("foo.bar.baz.xyzzy.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchFilenameAndExtensionWithMultiplePeriods() throws Exception {
        String definition = "/foo*.xyzzy.txt";
        String relativePath = "foo.bar.baz.qux.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".xyzzy.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/foo*.xyzzy.txt");
        Boolean actual = null;
        actual = rule.matches("foo.bar.baz.qux.txt");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testMatchWithoutLeadingForwardSlash() throws Exception {
        String definition = "foo*.xyzzy.txt";
        String relativePath = "foo.bar.baz.xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "foo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".xyzzy.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "foo*.xyzzy.txt");
        Boolean actual = null;
        actual = rule.matches("foo.bar.baz.xyzzy.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testMatchesOnlyRooted() throws Exception {
        String definition = "/path/to/some/foo*.xyzzy.txt";
        String relativePath = "foo.bar.baz.xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "path"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "to"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "some"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "oo"), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".xyzzy.txt"));
        RootedFileRule rule = new RootedFileRule(syntax, "/path/to/some/foo*.xyzzy.txt");
        Boolean actual = null;
        actual = rule.matches("foo.bar.baz.xyzzy.txt");
        Assert.assertFalse((boolean)actual);
    }
}

