/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.ignore.rules;

import io.swagger.codegen.ignore.rules.IgnoreLineParser;
import io.swagger.codegen.ignore.rules.ParserException;
import io.swagger.codegen.ignore.rules.Part;
import java.util.LinkedList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IgnoreLineParserTest {
    private IgnoreLineParser.Token verifyInputToSingleToken(String input, IgnoreLineParser.Token token) throws ParserException {
        List result = IgnoreLineParser.parse((String)input);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        IgnoreLineParser.Token actual = ((Part)result.get(0)).getToken();
        Assert.assertEquals((Object)actual, (Object)token);
        return actual;
    }

    @Test
    public void parseMatchAll() throws Exception {
        this.verifyInputToSingleToken("**", IgnoreLineParser.Token.MATCH_ALL);
    }

    @Test
    public void parseMatchAny() throws Exception {
        this.verifyInputToSingleToken("*", IgnoreLineParser.Token.MATCH_ANY);
    }

    @Test(expectedExceptions={ParserException.class}, expectedExceptionsMessageRegExp="Negation with no negated pattern\\.")
    public void parseNegate() throws Exception {
        this.verifyInputToSingleToken("!", IgnoreLineParser.Token.NEGATE);
        Assert.fail((String)"Expected simple pattern '!' to throw a ParserException.");
    }

    @Test
    public void parseComment() throws Exception {
        String input = "# This is a comment";
        Part actual = null;
        List result = IgnoreLineParser.parse((String)"# This is a comment");
        Assert.assertEquals((int)result.size(), (int)1);
        actual = (Part)result.get(0);
        Assert.assertEquals((Object)actual.getToken(), (Object)IgnoreLineParser.Token.COMMENT);
        Assert.assertEquals((String)actual.getValue(), (String)"# This is a comment");
    }

    @Test
    public void parseEscapedExclamation() throws Exception {
        String input = "\\!";
        this.verifyInputToSingleToken("\\!", IgnoreLineParser.Token.ESCAPED_EXCLAMATION);
    }

    @Test
    public void parseEscapedSpace() throws Exception {
        String input = "\\ ";
        this.verifyInputToSingleToken("\\ ", IgnoreLineParser.Token.ESCAPED_SPACE);
    }

    @Test
    public void parseDirectoryMarker() throws Exception {
        String input = "foo/";
        Part actual = null;
        List result = IgnoreLineParser.parse((String)"foo/");
        Assert.assertEquals((int)result.size(), (int)2);
        actual = (Part)result.get(0);
        Assert.assertEquals((Object)actual.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)actual.getValue(), (String)"foo");
        actual = (Part)result.get(1);
        Assert.assertEquals((Object)actual.getToken(), (Object)IgnoreLineParser.Token.DIRECTORY_MARKER);
    }

    @Test
    public void parseRooted() throws Exception {
        String input = "/abcd";
        Part actual = null;
        List result = IgnoreLineParser.parse((String)"/abcd");
        Assert.assertEquals((int)result.size(), (int)2);
        actual = (Part)result.get(0);
        Assert.assertEquals((Object)actual.getToken(), (Object)IgnoreLineParser.Token.ROOTED_MARKER);
        actual = (Part)result.get(1);
        Assert.assertEquals((Object)actual.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)actual.getValue(), (String)"abcd");
    }

    @Test
    public void parseComplex() throws Exception {
        String input = "**/abcd/**/foo/bar/sample.txt";
        Part current = null;
        LinkedList result = new LinkedList(IgnoreLineParser.parse((String)"**/abcd/**/foo/bar/sample.txt"));
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.MATCH_ALL);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.PATH_DELIM);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)current.getValue(), (String)"abcd");
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.PATH_DELIM);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.MATCH_ALL);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.PATH_DELIM);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)current.getValue(), (String)"foo");
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.PATH_DELIM);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)current.getValue(), (String)"bar");
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.PATH_DELIM);
        current = (Part)result.remove();
        Assert.assertEquals((Object)current.getToken(), (Object)IgnoreLineParser.Token.TEXT);
        Assert.assertEquals((String)current.getValue(), (String)"sample.txt");
    }

    @Test(expectedExceptions={ParserException.class}, expectedExceptionsMessageRegExp="The pattern \\*\\*\\* is invalid\\.")
    public void parseTripleStarPattern() throws Exception {
        String input = "should/throw/***/anywhere";
        List result = IgnoreLineParser.parse((String)"should/throw/***/anywhere");
        Assert.fail((String)"Expected pattern containing '***' to throw a ParserException.");
    }
}

