/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.ignore.rules;

import io.swagger.codegen.ignore.rules.FileRule;
import io.swagger.codegen.ignore.rules.IgnoreLineParser;
import io.swagger.codegen.ignore.rules.Part;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FileRuleTest {
    @Test
    public void testMatchComplex() throws Exception {
        String definition = "path/to/**/complex/*.txt";
        String relativePath = "path/to/some/nested/complex/xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "path"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "to"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.MATCH_ALL), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "complex"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".txt"));
        FileRule rule = new FileRule(syntax, "path/to/**/complex/*.txt");
        Boolean actual = null;
        actual = rule.matches("path/to/some/nested/complex/xyzzy.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testNonMatchComplex() throws Exception {
        String definition = "path/to/**/complex/*.txt";
        String relativePath = "path/to/some/nested/invalid/xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.ROOTED_MARKER), new Part(IgnoreLineParser.Token.TEXT, "path"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.TEXT, "to"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.MATCH_ALL), new Part(IgnoreLineParser.Token.TEXT, "complex"), new Part(IgnoreLineParser.Token.PATH_DELIM), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".txt"));
        FileRule rule = new FileRule(syntax, "path/to/**/complex/*.txt");
        Boolean actual = null;
        actual = rule.matches("path/to/some/nested/invalid/xyzzy.txt");
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testGlobbingRecursive() throws Exception {
        String definition = "*.txt";
        String relativePath = "path/to/some/nested/location/xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.MATCH_ALL), new Part(IgnoreLineParser.Token.DIRECTORY_MARKER), new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".txt"));
        FileRule rule = new FileRule(syntax, "*.txt");
        Boolean actual = rule.matches("path/to/some/nested/location/xyzzy.txt");
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testGlobbingNotRecursive() throws Exception {
        String definition = "*.txt";
        String relativePath = "path/to/some/nested/location/xyzzy.txt";
        List<Part> syntax = Arrays.asList(new Part(IgnoreLineParser.Token.MATCH_ANY), new Part(IgnoreLineParser.Token.TEXT, ".txt"));
        FileRule rule = new FileRule(syntax, "*.txt");
        Boolean actual = rule.matches("path/to/some/nested/location/xyzzy.txt");
        Assert.assertFalse((boolean)actual);
    }
}

