/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.go;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.GoClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GoModelTest {
    @Test(description="convert a simple Go model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int64");
        Assert.assertEquals((String)property1.name, (String)"Id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"int64");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"string");
        Assert.assertEquals((String)property2.name, (String)"Name");
        Assert.assertEquals((String)property2.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"string");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.complexType, (String)"time.Time");
        Assert.assertEquals((String)property3.datatype, (String)"time.Time");
        Assert.assertEquals((String)property3.name, (String)"CreatedAt");
        Assert.assertEquals((String)property3.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"time.Time");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"int64");
        Assert.assertEquals((String)property1.name, (String)"Id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"int64");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"[]string");
        Assert.assertEquals((String)property2.name, (String)"Urls");
        Assert.assertEquals((String)property2.baseType, (String)"array");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"map[string]string");
        Assert.assertEquals((String)property1.name, (String)"Translations");
        Assert.assertEquals((String)property1.baseType, (String)"map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"Children");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListProperty() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"[]Children");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"array");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapProperty() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"map[string]Children");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"map");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((int)cm.imports.size(), (int)1);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @DataProvider(name="modelNames")
    public static Object[][] primeNumbers() {
        return new Object[][]{{"sample", "Sample"}, {"sample_name", "SampleName"}, {"sample__name", "SampleName"}, {"/sample", "Sample"}, {"\\sample", "Sample"}, {"sample.name", "SampleName"}, {"_sample", "Sample"}};
    }

    @Test(dataProvider="modelNames", description="avoid inner class")
    public void modelNameTest(String name, String expectedName) {
        ModelImpl model = new ModelImpl();
        GoClientCodegen codegen = new GoClientCodegen();
        CodegenModel cm = codegen.fromModel(name, (Model)model);
        Assert.assertEquals((String)cm.name, (String)name);
        Assert.assertEquals((String)cm.classname, (String)expectedName);
    }
}

