/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.eiffel;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.EiffelClientCodegen;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EiffelModelTest {
    @Test(description="convert a simple Eiffel model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        EiffelClientCodegen codegen = new EiffelClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SAMPLE");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        Assert.assertEquals((int)cm.imports.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"INTEGER_64");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"INTEGER_64");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"STRING_32");
        Assert.assertEquals((String)property2.name, (String)"name");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property2.baseType, (String)"STRING_32");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertFalse((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.complexType, (String)"DATE_TIME");
        Assert.assertEquals((String)property3.datatype, (String)"DATE_TIME");
        Assert.assertEquals((String)property3.name, (String)"created_at");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property3.baseType, (String)"DATE_TIME");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        EiffelClientCodegen codegen = new EiffelClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SAMPLE");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"INTEGER_64");
        Assert.assertEquals((String)property1.name, (String)"id");
        Assert.assertEquals((String)property1.defaultValue, (String)"null");
        Assert.assertEquals((String)property1.baseType, (String)"INTEGER_64");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"LIST [STRING_32]");
        Assert.assertEquals((String)property2.name, (String)"urls");
        Assert.assertEquals((String)property2.baseType, (String)"LIST");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertFalse((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        Model model = this.getMapModel();
        EiffelClientCodegen codegen = new EiffelClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"SAMPLE");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"mapping");
        Assert.assertEquals((String)property1.datatype, (String)"STRING_TABLE[STRING_32]");
        Assert.assertEquals((String)property1.name, (String)"mapping");
        Assert.assertEquals((String)property1.baseType, (String)"STRING_TABLE");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isPrimitiveType);
    }

    private Model getMapModel() {
        return new ModelImpl().description("a sample model").property("mapping", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
    }
}

