/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.csharp;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.CSharpClientCodegen;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CsharpModelEnumTest {
    @Test(description="not override identical parent enums")
    public void overrideEnumTest() {
        StringProperty identicalEnumProperty = new StringProperty();
        identicalEnumProperty.setEnum(Arrays.asList("VALUE1", "VALUE2", "VALUE3"));
        StringProperty subEnumProperty = new StringProperty();
        subEnumProperty.setEnum(Arrays.asList("SUB1", "SUB2", "SUB3"));
        HashMap<String, StringProperty> parentProperties = new HashMap<String, StringProperty>();
        parentProperties.put("sharedThing", identicalEnumProperty);
        HashMap<String, StringProperty> subProperties = new HashMap<String, StringProperty>();
        subProperties.put("sharedThing", identicalEnumProperty);
        subProperties.put("unsharedThing", identicalEnumProperty);
        ModelImpl parentModel = new ModelImpl().description("parentModel");
        parentModel.setProperties(parentProperties);
        parentModel.name("parentModel");
        ModelImpl subModel = new ModelImpl().description("subModel");
        subModel.setProperties(subProperties);
        subModel.name("subModel");
        ComposedModel model = new ComposedModel().parent((Model)new RefModel(parentModel.getName())).child((Model)subModel).interfaces(new ArrayList());
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        HashMap<String, ModelImpl> allModels = new HashMap<String, ModelImpl>();
        allModels.put("ParentModel", parentModel);
        allModels.put("SubModel", subModel);
        CodegenModel cm = codegen.fromModel("sample", (Model)model, allModels);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"ParentModel");
        Assert.assertTrue((boolean)cm.imports.contains("ParentModel"));
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty enumVar = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)enumVar.baseName, (String)"unsharedThing");
        Assert.assertEquals((String)enumVar.datatype, (String)"string");
        Assert.assertEquals((String)enumVar.datatypeWithEnum, (String)"UnsharedThingEnum");
        Assert.assertTrue((boolean)enumVar.isEnum);
    }
}

