/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.csharp;

import com.google.common.collect.Sets;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.CSharpClientCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSharpModelTest {
    @Test(description="convert a model with array property to default List<T>")
    public void arrayPropertyTest() {
        Model model = this.getArrayTestModel();
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel generated = codegen.fromModel("sample", model);
        Assert.assertEquals((String)generated.name, (String)"sample");
        Assert.assertEquals((String)generated.classname, (String)"Sample");
        Assert.assertEquals((String)generated.description, (String)"a sample model");
        Assert.assertEquals((int)generated.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)generated.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"examples");
        Assert.assertEquals((String)property.getter, (String)"getExamples");
        Assert.assertEquals((String)property.setter, (String)"setExamples");
        Assert.assertEquals((String)property.datatype, (String)"List<string>");
        Assert.assertEquals((String)property.name, (String)"Examples");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"List");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with array property to Collection<T>")
    public void arrayPropertyCollectionOptionTest() {
        Model model = this.getArrayTestModel();
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        codegen.setUseCollection(true);
        CodegenModel generated = codegen.fromModel("sample", model);
        Assert.assertEquals((String)generated.name, (String)"sample");
        Assert.assertEquals((int)generated.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)generated.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"examples");
        Assert.assertEquals((String)property.name, (String)"Examples");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.datatype, (String)"Collection<string>");
        Assert.assertEquals((String)property.baseType, (String)"Collection");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    @Test(description="convert a model with array property to Collection<T>")
    public void arrayPropertyICollectionOptionTest() {
        Model model = this.getArrayTestModel();
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        codegen.setUseCollection(true);
        codegen.setReturnICollection(true);
        CodegenModel generated = codegen.fromModel("sample", model);
        Assert.assertEquals((String)generated.name, (String)"sample");
        Assert.assertEquals((int)generated.vars.size(), (int)2);
        CodegenProperty property = (CodegenProperty)generated.vars.get(1);
        Assert.assertEquals((String)property.baseName, (String)"examples");
        Assert.assertEquals((String)property.name, (String)"Examples");
        Assert.assertEquals((String)property.datatype, (String)"Collection<string>", (String)"returnICollection option should not modify property datatype");
        Assert.assertEquals((String)property.defaultValue, null);
        Assert.assertEquals((String)property.baseType, (String)"Collection", (String)"returnICollection option should not modify property baseType");
        Assert.assertEquals((String)property.containerType, (String)"array");
        Assert.assertFalse((boolean)property.required);
        Assert.assertTrue((boolean)property.isContainer);
    }

    private Model getArrayTestModel() {
        return new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("examples", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
    }

    @Test(description="convert a simple model")
    public void simpleModelTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("name", (Property)new StringProperty()).property("createdAt", (Property)new DateTimeProperty()).required("id").required("name");
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)3);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"long?");
        Assert.assertEquals((String)property1.name, (String)"Id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"long?");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"name");
        Assert.assertEquals((String)property2.datatype, (String)"string");
        Assert.assertEquals((String)property2.name, (String)"Name");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"string");
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        CodegenProperty property3 = (CodegenProperty)cm.vars.get(2);
        Assert.assertEquals((String)property3.baseName, (String)"createdAt");
        Assert.assertEquals((String)property3.datatype, (String)"DateTime?");
        Assert.assertEquals((String)property3.name, (String)"CreatedAt");
        Assert.assertNull((Object)property3.defaultValue);
        Assert.assertEquals((String)property3.baseType, (String)"DateTime?");
        Assert.assertFalse((boolean)property3.hasMore);
        Assert.assertFalse((boolean)property3.required);
        Assert.assertTrue((boolean)property3.isNotContainer);
    }

    @Test(description="convert a model with list property")
    public void listPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("id", (Property)new LongProperty()).property("urls", (Property)new ArrayProperty().items((Property)new StringProperty())).required("id");
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)2);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"id");
        Assert.assertEquals((String)property1.datatype, (String)"long?");
        Assert.assertEquals((String)property1.name, (String)"Id");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertEquals((String)property1.baseType, (String)"long?");
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        CodegenProperty property2 = (CodegenProperty)cm.vars.get(1);
        Assert.assertEquals((String)property2.baseName, (String)"urls");
        Assert.assertEquals((String)property2.datatype, (String)"List<string>");
        Assert.assertEquals((String)property2.name, (String)"Urls");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertEquals((String)property2.baseType, (String)"List");
        Assert.assertFalse((boolean)property2.hasMore);
        Assert.assertEquals((String)property2.containerType, (String)"array");
        Assert.assertFalse((boolean)property2.required);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isContainer);
    }

    @Test(description="convert a model with a map property")
    public void mapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("translations", (Property)new MapProperty().additionalProperties((Property)new StringProperty())).required("id");
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"translations");
        Assert.assertEquals((String)property1.datatype, (String)"Dictionary<string, string>");
        Assert.assertEquals((String)property1.name, (String)"Translations");
        Assert.assertEquals((String)property1.baseType, (String)"Dictionary");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
    }

    @Test(description="convert a model with complex property")
    public void complexPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new RefProperty("#/definitions/Children"));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.datatype, (String)"Children");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"Children");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isNotContainer);
    }

    @Test(description="convert a model with complex list property")
    public void complexListPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new ArrayProperty().items((Property)new RefProperty("#/definitions/Children")));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"List<Children>");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"List");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
    }

    @Test(description="convert a model with complex map property")
    public void complexMapPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample model").property("children", (Property)new MapProperty().additionalProperties((Property)new RefProperty("#/definitions/Children")));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a sample model");
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"children");
        Assert.assertEquals((String)property1.complexType, (String)"Children");
        Assert.assertEquals((String)property1.datatype, (String)"Dictionary<string, Children>");
        Assert.assertEquals((String)property1.name, (String)"Children");
        Assert.assertEquals((String)property1.baseType, (String)"Dictionary");
        Assert.assertEquals((String)property1.containerType, (String)"map");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }

    @Test(description="convert an array model")
    public void arrayModelTest() {
        ArrayModel model = new ArrayModel().description("an array model").items((Property)new RefProperty("#/definitions/Children"));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"an array model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"List<Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(description="convert an map model")
    public void mapModelTest() {
        ModelImpl model = new ModelImpl().description("a map model").additionalProperties((Property)new RefProperty("#/definitions/Children"));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.description, (String)"a map model");
        Assert.assertEquals((int)cm.vars.size(), (int)0);
        Assert.assertEquals((String)cm.parent, (String)"Dictionary<String, Children>");
        Assert.assertEquals((int)cm.imports.size(), (int)1);
        Assert.assertEquals((int)Sets.intersection((Set)cm.imports, (Set)Sets.newHashSet((Object[])new String[]{"Children"})).size(), (int)1);
    }

    @Test(description="convert an array of array models")
    public void arraysOfArraysModelTest() {
        ArrayModel model = new ArrayModel().description("a sample geolocation model").items((Property)new ArrayProperty().items((Property)new DoubleProperty()));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertEquals((String)cm.parent, (String)"List<List<double?>>");
    }

    @Test(description="convert an array of array properties")
    public void arraysOfArraysPropertyTest() {
        ModelImpl model = new ModelImpl().description("a sample geolocation model").property("points", (Property)new ArrayProperty().items((Property)new ArrayProperty().items((Property)new DoubleProperty())));
        CSharpClientCodegen codegen = new CSharpClientCodegen();
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"Sample");
        Assert.assertNull((Object)cm.parent);
        Assert.assertEquals((int)cm.vars.size(), (int)1);
        CodegenProperty property1 = (CodegenProperty)cm.vars.get(0);
        Assert.assertEquals((String)property1.baseName, (String)"points");
        Assert.assertNull((Object)property1.complexType);
        Assert.assertEquals((String)property1.datatype, (String)"List<List<double?>>");
        Assert.assertEquals((String)property1.name, (String)"Points");
        Assert.assertEquals((String)property1.baseType, (String)"List");
        Assert.assertEquals((String)property1.containerType, (String)"array");
        Assert.assertFalse((boolean)property1.required);
        Assert.assertTrue((boolean)property1.isContainer);
        Assert.assertFalse((boolean)property1.isNotContainer);
    }
}

