/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.config;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.auth.AuthParser;
import io.swagger.codegen.config.CodegenConfigurator;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParser;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import mockit.Expectations;
import mockit.FullVerifications;
import mockit.Injectable;
import mockit.Mocked;
import mockit.StrictExpectations;
import mockit.Tested;
import org.apache.commons.lang3.SerializationUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CodegenConfiguratorTest {
    @Mocked
    SwaggerParser parser;
    @Mocked
    AuthParser authParser;
    @Injectable
    Swagger swagger;
    @Mocked
    CodegenConfigLoader codegenConfigLoader;
    @Injectable
    List<AuthorizationValue> authorizationValues;
    @Tested
    CodegenConfigurator configurator;

    @Test
    public void testVerbose() throws Exception {
        this.configurator.setVerbose(true);
        new StrictExpectations(new Object[]{System.class}){
            {
                System.setProperty("debugSwagger", "");
                this.times = 1;
                System.setProperty("debugModels", "");
                this.times = 1;
                System.setProperty("debugOperations", "");
                this.times = 1;
                System.setProperty("debugSupportingFiles", "");
                this.times = 1;
            }
        };
        this.setupAndRunGenericTest(this.configurator);
    }

    @Test
    public void testTemplateDir() throws Exception {
        String templateDir = "src/test/resources";
        this.configurator.setTemplateDir("src/test/resources");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "templateDir", CodegenConfiguratorTest.toAbsolutePathDir("src/test/resources"));
    }

    @Test
    public void testSystemProperties() throws Exception {
        this.configurator.addSystemProperty("hello", "world").addSystemProperty("foo", "bar");
        new Expectations(new Object[]{System.class}){
            {
                System.setProperty("hello", "world");
                this.times = 1;
                System.setProperty("foo", "bar");
                this.times = 1;
            }
        };
        this.setupAndRunGenericTest(this.configurator);
    }

    @Test
    public void testSkipOverwrite() throws Exception {
        CodegenConfigurator configurator1 = new CodegenConfigurator();
        configurator1.setSkipOverwrite(true);
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(configurator1);
        Assert.assertTrue((boolean)clientOptInput.getConfig().isSkipOverwrite());
        CodegenConfigurator configurator2 = new CodegenConfigurator();
        configurator1.setSkipOverwrite(true);
        clientOptInput = this.setupAndRunGenericTest(configurator2);
        Assert.assertFalse((boolean)clientOptInput.getConfig().isSkipOverwrite());
    }

    @Test
    public void testApiPackage() throws Exception {
        String apiPackage = "io.foo.bar.api";
        this.configurator.setApiPackage("io.foo.bar.api");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "apiPackage", "io.foo.bar.api");
    }

    @Test
    public void testModelPackage() throws Exception {
        String modelPackage = "io.foo.bar.models";
        this.configurator.setModelPackage("io.foo.bar.models");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "modelPackage", "io.foo.bar.models");
    }

    @Test
    public void testInstantiationTypes() throws Exception {
        this.configurator.addInstantiationType("foo", "bar").addInstantiationType("hello", "world");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().instantiationTypes(), "foo", "bar");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().instantiationTypes(), "hello", "world");
    }

    @Test
    public void testTypeMappings() throws Exception {
        this.configurator.addTypeMapping("foo", "bar").addTypeMapping("hello", "world");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().typeMapping(), "foo", "bar");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().typeMapping(), "hello", "world");
    }

    @Test
    public void testAdditionalProperties() throws Exception {
        this.configurator.addAdditionalProperty("foo", (Object)"bar").addAdditionalProperty("hello", (Object)"world").addAdditionalProperty("supportJava6", (Object)false).addAdditionalProperty("useRxJava", (Object)true);
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "foo", "bar");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "hello", "world");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "supportJava6", false);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "useRxJava", true);
    }

    @Test
    public void testLanguageSpecificPrimitives() throws Exception {
        this.configurator.addLanguageSpecificPrimitive("foo").addLanguageSpecificPrimitive("bar").addLanguageSpecificPrimitive("hello").addLanguageSpecificPrimitive("world");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        Assert.assertTrue((boolean)clientOptInput.getConfig().languageSpecificPrimitives().contains("foo"));
        Assert.assertTrue((boolean)clientOptInput.getConfig().languageSpecificPrimitives().contains("bar"));
        Assert.assertTrue((boolean)clientOptInput.getConfig().languageSpecificPrimitives().contains("hello"));
        Assert.assertTrue((boolean)clientOptInput.getConfig().languageSpecificPrimitives().contains("world"));
    }

    @Test
    public void testImportMappings() throws Exception {
        this.configurator.addImportMapping("foo", "bar").addImportMapping("hello", "world");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().importMapping(), "foo", "bar");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().importMapping(), "hello", "world");
    }

    @Test
    public void testInvokerPackage() throws Exception {
        String invokerPackage = "io.foo.bar.models";
        this.configurator.setInvokerPackage("io.foo.bar.models");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "invokerPackage", "io.foo.bar.models");
    }

    @Test
    public void testGroupId() throws Exception {
        String expectedValue = "io.foo.bar.models";
        this.configurator.setGroupId("io.foo.bar.models");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "groupId", "io.foo.bar.models");
    }

    @Test
    public void testArtifactId() throws Exception {
        String expectedValue = "io.foo.bar.models";
        this.configurator.setArtifactId("io.foo.bar.models");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "artifactId", "io.foo.bar.models");
    }

    @Test
    public void testArtifactVersion() throws Exception {
        String expectedValue = "1.2.3";
        this.configurator.setArtifactVersion("1.2.3");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "artifactVersion", "1.2.3");
    }

    @Test
    public void testLibrary() throws Exception {
        String expectedValue = "jersey2";
        this.configurator.setLibrary("jersey2");
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        Assert.assertEquals((String)clientOptInput.getConfig().getLibrary(), (String)"jersey2");
    }

    @Test
    public void testDynamicProperties() throws Exception {
        this.configurator.addDynamicProperty("localVariablePrefix", (Object)"_");
        this.configurator.addDynamicProperty("supportJava6", (Object)false);
        this.configurator.addDynamicProperty("useRxJava", (Object)true);
        ClientOptInput clientOptInput = this.setupAndRunGenericTest(this.configurator);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "localVariablePrefix", "_");
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "supportJava6", false);
        CodegenConfiguratorTest.assertValueInMap(clientOptInput.getConfig().additionalProperties(), "useRxJava", true);
    }

    @Test
    public void testFromFile() throws Exception {
        CodegenConfigurator configurator = CodegenConfigurator.fromFile((String)"src/test/resources/sampleConfig.json");
        Assert.assertEquals((String)configurator.getLang(), (String)"java");
        Assert.assertEquals((String)configurator.getInputSpec(), (String)"swagger.yaml");
        Assert.assertEquals((String)configurator.getOutputDir(), (String)CodegenConfiguratorTest.toAbsolutePathDir("src/gen/java"));
        Assert.assertEquals((boolean)configurator.isVerbose(), (boolean)true);
        Assert.assertEquals((boolean)configurator.isSkipOverwrite(), (boolean)true);
        Assert.assertEquals((String)configurator.getTemplateDir(), (String)CodegenConfiguratorTest.toAbsolutePathDir("src/main/resources"));
        Assert.assertEquals((String)configurator.getAuth(), (String)"hello:world");
        Assert.assertEquals((String)configurator.getApiPackage(), (String)"io.something.api");
        Assert.assertEquals((String)configurator.getModelPackage(), (String)"io.something.models");
        Assert.assertEquals((String)configurator.getInvokerPackage(), (String)"io.something.invoker");
        Assert.assertEquals((String)configurator.getGroupId(), (String)"io.something");
        Assert.assertEquals((String)configurator.getArtifactId(), (String)"awesome-api");
        Assert.assertEquals((String)configurator.getArtifactVersion(), (String)"1.2.3");
        Assert.assertEquals((String)configurator.getLibrary(), (String)"jersey2");
        Assert.assertEquals((int)configurator.getSystemProperties().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getSystemProperties(), "systemProp1", "value1");
        Assert.assertEquals((int)configurator.getInstantiationTypes().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getInstantiationTypes(), "hello", "world");
        Assert.assertEquals((int)configurator.getTypeMappings().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getTypeMappings(), "foo", "bar");
        Assert.assertEquals((int)configurator.getAdditionalProperties().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getAdditionalProperties(), "addtProp1", "value2");
        Assert.assertEquals((int)configurator.getImportMappings().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getImportMappings(), "type1", "import1");
        Assert.assertEquals((int)configurator.getLanguageSpecificPrimitives().size(), (int)1);
        Assert.assertTrue((boolean)configurator.getLanguageSpecificPrimitives().contains("rolex"));
        Assert.assertEquals((int)configurator.getDynamicProperties().size(), (int)1);
        CodegenConfiguratorTest.assertValueInMap(configurator.getDynamicProperties(), "localVariablePrefix", "_");
        Assert.assertEquals((String)configurator.getIgnoreFileOverride(), (String)"/path/to/override/.swagger-codegen-ignore");
    }

    @Test
    public void testCodegenConfiguratorIsSerializable() {
        CodegenConfigurator configurator = CodegenConfigurator.fromFile((String)"src/test/resources/sampleConfig.json");
        SerializationUtils.serialize((Serializable)configurator);
    }

    private ClientOptInput setupAndRunGenericTest(CodegenConfigurator configurator) {
        String spec = "swagger.yaml";
        String lang = "java";
        String outputDir = "src/test/java";
        String expectedAuth = "hello:world";
        configurator.setLang("java").setOutputDir("src/test/java").setInputSpec("swagger.yaml").setAuth("hello:world");
        JavaClientCodegen config = new JavaClientCodegen();
        this.setupStandardExpectations("swagger.yaml", "java", configurator.getAuth(), (CodegenConfig)config);
        ClientOptInput result = configurator.toClientOptInput();
        new FullVerifications(){};
        String expectedOutputDir = CodegenConfiguratorTest.toAbsolutePathDir("src/test/java");
        Assert.assertEquals((String)result.getConfig().getOutputDir(), (String)expectedOutputDir);
        return result;
    }

    private static String toAbsolutePathDir(String outputDir) {
        return Paths.get(outputDir, new String[0]).toAbsolutePath().toAbsolutePath().toString();
    }

    private void setupStandardExpectations(final String spec, final String languageName, final String auth, final CodegenConfig config) {
        new StrictExpectations(){
            {
                CodegenConfigLoader.forName((String)languageName);
                this.times = 1;
                this.result = config;
                AuthParser.parse((String)auth);
                this.times = 1;
                this.result = CodegenConfiguratorTest.this.authorizationValues;
                new SwaggerParser();
                this.times = 1;
                this.result = CodegenConfiguratorTest.this.parser;
                CodegenConfiguratorTest.this.parser.read(spec, CodegenConfiguratorTest.this.authorizationValues, true);
                this.times = 1;
                this.result = CodegenConfiguratorTest.this.swagger;
            }
        };
    }

    private static void assertValueInMap(Map<?, ?> map, String propertyKey, Object expectedPropertyValue) {
        Assert.assertTrue((boolean)map.containsKey(propertyKey));
        Assert.assertEquals(map.get(propertyKey), (Object)expectedPropertyValue);
    }
}

