/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.bash;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.languages.BashClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BashTest {
    @Test(description="test basic petstore operation with Bash extensions")
    public void petstoreOperationTest() {
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/petstore-bash.json");
        BashClientCodegen codegen = new BashClientCodegen();
        Operation findPetsByStatusOperation = swagger.getPath("/pet/findByStatus").getGet();
        CodegenOperation op = codegen.fromOperation("/pet/findByStatus", "GET", findPetsByStatusOperation, swagger.getDefinitions(), swagger);
        Assert.assertTrue((boolean)op.vendorExtensions.containsKey("x-code-samples"));
        Assert.assertEquals(op.vendorExtensions.get("x-bash-codegen-description"), (Object)"Multiple status 'values' can be provided with comma separated strings");
    }

    @Test(description="test basic petstore operation with example body")
    public void petstoreParameterExampleTest() {
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/petstore-bash.json");
        BashClientCodegen codegen = new BashClientCodegen();
        Operation addPetOperation = swagger.getPath("/pet").getPost();
        CodegenOperation op = codegen.fromOperation("/pet", "POST", addPetOperation, swagger.getDefinitions(), swagger);
        Assert.assertEquals((int)op.bodyParams.size(), (int)1);
        CodegenParameter pet = (CodegenParameter)op.bodyParams.get(0);
        Assert.assertTrue((boolean)pet.vendorExtensions.containsKey("x-codegen-body-example"));
    }

    @Test(description="test Bash client codegen escapeText method")
    public void escapeTextTest() {
        BashClientCodegen codegen = new BashClientCodegen();
        Assert.assertEquals((String)codegen.escapeText("\\/"), (String)"/");
        Assert.assertEquals((String)codegen.escapeText("\\"), (String)"\\\\");
        codegen.setProcessMarkdown(false);
        Assert.assertEquals((String)codegen.escapeText("__Bold text__"), (String)"__Bold text__");
        Assert.assertEquals((String)codegen.escapeText("**Bold text**"), (String)"**Bold text**");
        Assert.assertEquals((String)codegen.escapeText("*Italic text*"), (String)"*Italic text*");
        Assert.assertEquals((String)codegen.escapeText("_Italic text_"), (String)"_Italic text_");
        codegen.setProcessMarkdown(true);
        Assert.assertEquals((String)codegen.escapeText("__Bold text__"), (String)"$(tput bold) Bold text $(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("**Bold text**"), (String)"$(tput bold) Bold text $(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("*Italic text*"), (String)"$(tput dim) Italic text $(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("_Italic text_"), (String)"$(tput dim) Italic text $(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("# SECTION NAME"), (String)"\n$(tput bold)$(tput setaf 7)SECTION NAME$(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("## SECTION NAME"), (String)"\n$(tput bold)$(tput setaf 7)SECTION NAME$(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("### SECTION NAME"), (String)"\n$(tput bold)$(tput setaf 7)SECTION NAME$(tput sgr0)");
        Assert.assertEquals((String)codegen.escapeText("```\nnice -n 100 mvn test\n```"), (String)"\n---\nnice -n 100 mvn test\n---");
    }

    @Test(description="test Bash client codegen escapeUnsafeCharacters method")
    public void escapeUnsafeCharactersTest() {
        BashClientCodegen codegen = new BashClientCodegen();
        Assert.assertEquals((String)codegen.escapeUnsafeCharacters("`no backticks`"), (String)"'no backticks'");
    }

    @Test(description="test Bash client codegen escapeReservedWord method")
    public void escapeReservedWordTest() {
        BashClientCodegen codegen = new BashClientCodegen();
        Assert.assertEquals((String)codegen.escapeReservedWord("case"), (String)"_case");
    }
}

