/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.apex;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.ApexClientCodegen;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.PasswordProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ApexModelTest {
    @Test(description="convert a simple apex model with provided examples")
    public void examplesProvidedTest() {
        BaseIntegerProperty baseIntProp = new BaseIntegerProperty();
        baseIntProp.setExample((Object)5);
        PasswordProperty passwordProp = new PasswordProperty();
        passwordProp.setExample("password");
        UUIDProperty uuidProp = new UUIDProperty();
        uuidProp.setExample("793574b2-3a8e-4f6c-bfa5-c6929dc29f8a");
        ModelImpl model = new ModelImpl().property("boolProp", (Property)new BooleanProperty().example(Boolean.valueOf(false))).property("dateProp", (Property)new DateProperty().example("1985-04-12")).property("dateTimeProp", (Property)new DateTimeProperty().example("1985-04-12T23:20:50.52Z")).property("decimalProp", (Property)new DecimalProperty().example("19.99")).property("doubleProp", (Property)new DoubleProperty().example(Double.valueOf(2.95))).property("emailProp", (Property)new EmailProperty().example("info@example.com")).property("floatProp", (Property)new FloatProperty().example(Float.valueOf(3.49f))).property("intProp", (Property)new IntegerProperty().example(Integer.valueOf(10))).property("longProp", (Property)new LongProperty().example(Long.valueOf(100000L))).property("stringProp", (Property)new StringProperty().example("foo")).property("baseIntProp", (Property)baseIntProp).property("passwordProp", (Property)passwordProp).property("uuidProp", (Property)uuidProp);
        ApexClientCodegen codegen = new ApexClientCodegen();
        codegen.setClassPrefix("Prefix");
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"PrefixSample");
        Assert.assertEquals((int)cm.vars.size(), (int)13);
        List vars = cm.vars;
        CodegenProperty property1 = (CodegenProperty)vars.get(0);
        Assert.assertEquals((String)property1.name, (String)"boolProp");
        Assert.assertEquals((String)property1.baseName, (String)"boolProp");
        Assert.assertEquals((String)property1.datatype, (String)"Boolean");
        Assert.assertEquals((String)property1.baseType, (String)"Boolean");
        Assert.assertEquals((String)property1.example, (String)"false");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        Assert.assertTrue((boolean)property1.isBoolean);
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.name, (String)"dateProp");
        Assert.assertEquals((String)property2.baseName, (String)"dateProp");
        Assert.assertEquals((String)property2.datatype, (String)"Date");
        Assert.assertEquals((String)property2.baseType, (String)"Date");
        Assert.assertEquals((String)property2.example, (String)"Date.newInstance(1985, 4, 12)");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        Assert.assertTrue((boolean)property2.isDate);
        CodegenProperty property3 = (CodegenProperty)vars.get(2);
        Assert.assertEquals((String)property3.name, (String)"dateTimeProp");
        Assert.assertEquals((String)property3.baseName, (String)"dateTimeProp");
        Assert.assertEquals((String)property3.datatype, (String)"Datetime");
        Assert.assertEquals((String)property3.baseType, (String)"Datetime");
        Assert.assertEquals((String)property3.example, (String)"Datetime.newInstanceGmt(1985, 4, 12, 23, 20, 50)");
        Assert.assertNull((Object)property3.defaultValue);
        Assert.assertTrue((boolean)property3.hasMore);
        Assert.assertTrue((boolean)property3.isPrimitiveType);
        Assert.assertTrue((boolean)property3.isNotContainer);
        Assert.assertTrue((boolean)property3.isDateTime);
        CodegenProperty property4 = (CodegenProperty)vars.get(3);
        Assert.assertEquals((String)property4.name, (String)"decimalProp");
        Assert.assertEquals((String)property4.baseName, (String)"decimalProp");
        Assert.assertEquals((String)property4.datatype, (String)"Double");
        Assert.assertEquals((String)property4.baseType, (String)"Double");
        Assert.assertEquals((String)property4.example, (String)"19.99");
        Assert.assertNull((Object)property4.defaultValue);
        Assert.assertTrue((boolean)property4.hasMore);
        Assert.assertTrue((boolean)property4.isPrimitiveType);
        Assert.assertTrue((boolean)property4.isNotContainer);
        CodegenProperty property5 = (CodegenProperty)vars.get(4);
        Assert.assertEquals((String)property5.name, (String)"doubleProp");
        Assert.assertEquals((String)property5.baseName, (String)"doubleProp");
        Assert.assertEquals((String)property5.datatype, (String)"Double");
        Assert.assertEquals((String)property5.baseType, (String)"Double");
        Assert.assertEquals((String)property5.example, (String)"2.95");
        Assert.assertNull((Object)property5.defaultValue);
        Assert.assertTrue((boolean)property5.hasMore);
        Assert.assertTrue((boolean)property5.isPrimitiveType);
        Assert.assertTrue((boolean)property5.isNotContainer);
        Assert.assertTrue((boolean)property5.isDouble);
        CodegenProperty property6 = (CodegenProperty)vars.get(5);
        Assert.assertEquals((String)property6.name, (String)"emailProp");
        Assert.assertEquals((String)property6.baseName, (String)"emailProp");
        Assert.assertEquals((String)property6.datatype, (String)"String");
        Assert.assertEquals((String)property6.baseType, (String)"String");
        Assert.assertEquals((String)property6.example, (String)"'info@example.com'");
        Assert.assertNull((Object)property6.defaultValue);
        Assert.assertTrue((boolean)property6.hasMore);
        Assert.assertTrue((boolean)property6.isPrimitiveType);
        Assert.assertTrue((boolean)property6.isNotContainer);
        Assert.assertTrue((boolean)property6.isString);
        CodegenProperty property7 = (CodegenProperty)vars.get(6);
        Assert.assertEquals((String)property7.name, (String)"floatProp");
        Assert.assertEquals((String)property7.baseName, (String)"floatProp");
        Assert.assertEquals((String)property7.datatype, (String)"Double");
        Assert.assertEquals((String)property7.baseType, (String)"Double");
        Assert.assertEquals((String)property7.example, (String)"3.49");
        Assert.assertNull((Object)property7.defaultValue);
        Assert.assertTrue((boolean)property7.hasMore);
        Assert.assertTrue((boolean)property7.isPrimitiveType);
        Assert.assertTrue((boolean)property7.isNotContainer);
        Assert.assertTrue((boolean)property7.isFloat);
        CodegenProperty property8 = (CodegenProperty)vars.get(7);
        Assert.assertEquals((String)property8.name, (String)"intProp");
        Assert.assertEquals((String)property8.baseName, (String)"intProp");
        Assert.assertEquals((String)property8.datatype, (String)"Integer");
        Assert.assertEquals((String)property8.baseType, (String)"Integer");
        Assert.assertEquals((String)property8.example, (String)"10");
        Assert.assertNull((Object)property8.defaultValue);
        Assert.assertTrue((boolean)property8.hasMore);
        Assert.assertTrue((boolean)property8.isPrimitiveType);
        Assert.assertTrue((boolean)property8.isNotContainer);
        Assert.assertTrue((boolean)property8.isInteger);
        CodegenProperty property9 = (CodegenProperty)vars.get(8);
        Assert.assertEquals((String)property9.name, (String)"longProp");
        Assert.assertEquals((String)property9.baseName, (String)"longProp");
        Assert.assertEquals((String)property9.datatype, (String)"Long");
        Assert.assertEquals((String)property9.baseType, (String)"Long");
        Assert.assertEquals((String)property9.example, (String)"100000L");
        Assert.assertNull((Object)property9.defaultValue);
        Assert.assertTrue((boolean)property9.hasMore);
        Assert.assertTrue((boolean)property9.isPrimitiveType);
        Assert.assertTrue((boolean)property9.isNotContainer);
        Assert.assertTrue((boolean)property9.isLong);
        CodegenProperty property10 = (CodegenProperty)vars.get(9);
        Assert.assertEquals((String)property10.name, (String)"stringProp");
        Assert.assertEquals((String)property10.baseName, (String)"stringProp");
        Assert.assertEquals((String)property10.datatype, (String)"String");
        Assert.assertEquals((String)property10.baseType, (String)"String");
        Assert.assertEquals((String)property10.example, (String)"'foo'");
        Assert.assertNull((Object)property10.defaultValue);
        Assert.assertTrue((boolean)property10.hasMore);
        Assert.assertTrue((boolean)property10.isPrimitiveType);
        Assert.assertTrue((boolean)property10.isNotContainer);
        Assert.assertTrue((boolean)property10.isString);
        CodegenProperty property11 = (CodegenProperty)vars.get(10);
        Assert.assertEquals((String)property11.name, (String)"baseIntProp");
        Assert.assertEquals((String)property11.baseName, (String)"baseIntProp");
        Assert.assertEquals((String)property11.datatype, (String)"Integer");
        Assert.assertEquals((String)property11.baseType, (String)"Integer");
        Assert.assertEquals((String)property11.example, (String)"5");
        Assert.assertNull((Object)property11.defaultValue);
        Assert.assertTrue((boolean)property11.hasMore);
        Assert.assertTrue((boolean)property11.isPrimitiveType);
        Assert.assertTrue((boolean)property11.isNotContainer);
        Assert.assertTrue((boolean)property11.isInteger);
        CodegenProperty property12 = (CodegenProperty)vars.get(11);
        Assert.assertEquals((String)property12.name, (String)"passwordProp");
        Assert.assertEquals((String)property12.baseName, (String)"passwordProp");
        Assert.assertEquals((String)property12.datatype, (String)"String");
        Assert.assertEquals((String)property12.baseType, (String)"String");
        Assert.assertEquals((String)property12.example, (String)"'password'");
        Assert.assertNull((Object)property12.defaultValue);
        Assert.assertTrue((boolean)property12.hasMore);
        Assert.assertTrue((boolean)property12.isPrimitiveType);
        Assert.assertTrue((boolean)property12.isNotContainer);
        CodegenProperty property13 = (CodegenProperty)vars.get(12);
        Assert.assertEquals((String)property13.name, (String)"uuidProp");
        Assert.assertEquals((String)property13.baseName, (String)"uuidProp");
        Assert.assertEquals((String)property13.datatype, (String)"String");
        Assert.assertEquals((String)property13.baseType, (String)"String");
        Assert.assertEquals((String)property13.example, (String)"'793574b2-3a8e-4f6c-bfa5-c6929dc29f8a'");
        Assert.assertNull((Object)property13.defaultValue);
        Assert.assertFalse((boolean)property13.hasMore);
        Assert.assertTrue((boolean)property13.isPrimitiveType);
        Assert.assertTrue((boolean)property13.isNotContainer);
    }

    @Test(description="convert a simple apex model with default examples")
    public void defaultExamplesTest() {
        ModelImpl model = new ModelImpl().property("boolProp", (Property)new BooleanProperty()).property("dateProp", (Property)new DateProperty()).property("dateTimeProp", (Property)new DateTimeProperty()).property("decimalProp", (Property)new DecimalProperty()).property("doubleProp", (Property)new DoubleProperty()).property("emailProp", (Property)new EmailProperty()).property("floatProp", (Property)new FloatProperty()).property("intProp", (Property)new IntegerProperty()).property("longProp", (Property)new LongProperty()).property("stringProp", (Property)new StringProperty()).property("baseIntProp", (Property)new BaseIntegerProperty()).property("passwordProp", (Property)new PasswordProperty()).property("uuidProp", (Property)new UUIDProperty()).property("byteArrProp", (Property)new ByteArrayProperty()).property("binaryProp", (Property)new BinaryProperty());
        ApexClientCodegen codegen = new ApexClientCodegen();
        codegen.setClassPrefix("Prefix");
        CodegenModel cm = codegen.fromModel("sample", (Model)model);
        Assert.assertEquals((String)cm.name, (String)"sample");
        Assert.assertEquals((String)cm.classname, (String)"PrefixSample");
        Assert.assertEquals((int)cm.vars.size(), (int)15);
        List vars = cm.vars;
        CodegenProperty property1 = (CodegenProperty)vars.get(0);
        Assert.assertEquals((String)property1.name, (String)"boolProp");
        Assert.assertEquals((String)property1.baseName, (String)"boolProp");
        Assert.assertEquals((String)property1.datatype, (String)"Boolean");
        Assert.assertEquals((String)property1.baseType, (String)"Boolean");
        Assert.assertEquals((String)property1.example, (String)"true");
        Assert.assertNull((Object)property1.defaultValue);
        Assert.assertTrue((boolean)property1.hasMore);
        Assert.assertTrue((boolean)property1.isPrimitiveType);
        Assert.assertTrue((boolean)property1.isNotContainer);
        Assert.assertTrue((boolean)property1.isBoolean);
        CodegenProperty property2 = (CodegenProperty)vars.get(1);
        Assert.assertEquals((String)property2.name, (String)"dateProp");
        Assert.assertEquals((String)property2.baseName, (String)"dateProp");
        Assert.assertEquals((String)property2.datatype, (String)"Date");
        Assert.assertEquals((String)property2.baseType, (String)"Date");
        Assert.assertEquals((String)property2.example, (String)"Date.newInstance(2000, 1, 23)");
        Assert.assertNull((Object)property2.defaultValue);
        Assert.assertTrue((boolean)property2.hasMore);
        Assert.assertTrue((boolean)property2.isPrimitiveType);
        Assert.assertTrue((boolean)property2.isNotContainer);
        Assert.assertTrue((boolean)property2.isDate);
        CodegenProperty property3 = (CodegenProperty)vars.get(2);
        Assert.assertEquals((String)property3.name, (String)"dateTimeProp");
        Assert.assertEquals((String)property3.baseName, (String)"dateTimeProp");
        Assert.assertEquals((String)property3.datatype, (String)"Datetime");
        Assert.assertEquals((String)property3.baseType, (String)"Datetime");
        Assert.assertEquals((String)property3.example, (String)"Datetime.newInstanceGmt(2000, 1, 23, 4, 56, 7)");
        Assert.assertNull((Object)property3.defaultValue);
        Assert.assertTrue((boolean)property3.hasMore);
        Assert.assertTrue((boolean)property3.isPrimitiveType);
        Assert.assertTrue((boolean)property3.isNotContainer);
        Assert.assertTrue((boolean)property3.isDateTime);
        CodegenProperty property4 = (CodegenProperty)vars.get(3);
        Assert.assertEquals((String)property4.name, (String)"decimalProp");
        Assert.assertEquals((String)property4.baseName, (String)"decimalProp");
        Assert.assertEquals((String)property4.datatype, (String)"Double");
        Assert.assertEquals((String)property4.baseType, (String)"Double");
        Assert.assertEquals((String)property4.example, (String)"1.3579");
        Assert.assertNull((Object)property4.defaultValue);
        Assert.assertTrue((boolean)property4.hasMore);
        Assert.assertTrue((boolean)property4.isPrimitiveType);
        Assert.assertTrue((boolean)property4.isNotContainer);
        CodegenProperty property5 = (CodegenProperty)vars.get(4);
        Assert.assertEquals((String)property5.name, (String)"doubleProp");
        Assert.assertEquals((String)property5.baseName, (String)"doubleProp");
        Assert.assertEquals((String)property5.datatype, (String)"Double");
        Assert.assertEquals((String)property5.baseType, (String)"Double");
        Assert.assertEquals((String)property5.example, (String)"1.3579");
        Assert.assertNull((Object)property5.defaultValue);
        Assert.assertTrue((boolean)property5.hasMore);
        Assert.assertTrue((boolean)property5.isPrimitiveType);
        Assert.assertTrue((boolean)property5.isNotContainer);
        Assert.assertTrue((boolean)property5.isDouble);
        CodegenProperty property6 = (CodegenProperty)vars.get(5);
        Assert.assertEquals((String)property6.name, (String)"emailProp");
        Assert.assertEquals((String)property6.baseName, (String)"emailProp");
        Assert.assertEquals((String)property6.datatype, (String)"String");
        Assert.assertEquals((String)property6.baseType, (String)"String");
        Assert.assertEquals((String)property6.example, (String)"'example@example.com'");
        Assert.assertNull((Object)property6.defaultValue);
        Assert.assertTrue((boolean)property6.hasMore);
        Assert.assertTrue((boolean)property6.isPrimitiveType);
        Assert.assertTrue((boolean)property6.isNotContainer);
        Assert.assertTrue((boolean)property6.isString);
        CodegenProperty property7 = (CodegenProperty)vars.get(6);
        Assert.assertEquals((String)property7.name, (String)"floatProp");
        Assert.assertEquals((String)property7.baseName, (String)"floatProp");
        Assert.assertEquals((String)property7.datatype, (String)"Double");
        Assert.assertEquals((String)property7.baseType, (String)"Double");
        Assert.assertEquals((String)property7.example, (String)"1.3579");
        Assert.assertNull((Object)property7.defaultValue);
        Assert.assertTrue((boolean)property7.hasMore);
        Assert.assertTrue((boolean)property7.isPrimitiveType);
        Assert.assertTrue((boolean)property7.isNotContainer);
        Assert.assertTrue((boolean)property7.isFloat);
        CodegenProperty property8 = (CodegenProperty)vars.get(7);
        Assert.assertEquals((String)property8.name, (String)"intProp");
        Assert.assertEquals((String)property8.baseName, (String)"intProp");
        Assert.assertEquals((String)property8.datatype, (String)"Integer");
        Assert.assertEquals((String)property8.baseType, (String)"Integer");
        Assert.assertEquals((String)property8.example, (String)"123");
        Assert.assertNull((Object)property8.defaultValue);
        Assert.assertTrue((boolean)property8.hasMore);
        Assert.assertTrue((boolean)property8.isPrimitiveType);
        Assert.assertTrue((boolean)property8.isNotContainer);
        Assert.assertTrue((boolean)property8.isInteger);
        CodegenProperty property9 = (CodegenProperty)vars.get(8);
        Assert.assertEquals((String)property9.name, (String)"longProp");
        Assert.assertEquals((String)property9.baseName, (String)"longProp");
        Assert.assertEquals((String)property9.datatype, (String)"Long");
        Assert.assertEquals((String)property9.baseType, (String)"Long");
        Assert.assertEquals((String)property9.example, (String)"123456789L");
        Assert.assertNull((Object)property9.defaultValue);
        Assert.assertTrue((boolean)property9.hasMore);
        Assert.assertTrue((boolean)property9.isPrimitiveType);
        Assert.assertTrue((boolean)property9.isNotContainer);
        Assert.assertTrue((boolean)property9.isLong);
        CodegenProperty property10 = (CodegenProperty)vars.get(9);
        Assert.assertEquals((String)property10.name, (String)"stringProp");
        Assert.assertEquals((String)property10.baseName, (String)"stringProp");
        Assert.assertEquals((String)property10.datatype, (String)"String");
        Assert.assertEquals((String)property10.baseType, (String)"String");
        Assert.assertEquals((String)property10.example, (String)"'aeiou'");
        Assert.assertNull((Object)property10.defaultValue);
        Assert.assertTrue((boolean)property10.hasMore);
        Assert.assertTrue((boolean)property10.isPrimitiveType);
        Assert.assertTrue((boolean)property10.isNotContainer);
        Assert.assertTrue((boolean)property10.isString);
        CodegenProperty property11 = (CodegenProperty)vars.get(10);
        Assert.assertEquals((String)property11.name, (String)"baseIntProp");
        Assert.assertEquals((String)property11.baseName, (String)"baseIntProp");
        Assert.assertEquals((String)property11.datatype, (String)"Integer");
        Assert.assertEquals((String)property11.baseType, (String)"Integer");
        Assert.assertEquals((String)property11.example, (String)"123");
        Assert.assertNull((Object)property11.defaultValue);
        Assert.assertTrue((boolean)property11.hasMore);
        Assert.assertTrue((boolean)property11.isPrimitiveType);
        Assert.assertTrue((boolean)property11.isNotContainer);
        Assert.assertTrue((boolean)property11.isInteger);
        CodegenProperty property12 = (CodegenProperty)vars.get(11);
        Assert.assertEquals((String)property12.name, (String)"passwordProp");
        Assert.assertEquals((String)property12.baseName, (String)"passwordProp");
        Assert.assertEquals((String)property12.datatype, (String)"String");
        Assert.assertEquals((String)property12.baseType, (String)"String");
        Assert.assertEquals((String)property12.example, (String)"'password123'");
        Assert.assertNull((Object)property12.defaultValue);
        Assert.assertTrue((boolean)property12.hasMore);
        Assert.assertTrue((boolean)property12.isPrimitiveType);
        Assert.assertTrue((boolean)property12.isNotContainer);
        CodegenProperty property13 = (CodegenProperty)vars.get(12);
        Assert.assertEquals((String)property13.name, (String)"uuidProp");
        Assert.assertEquals((String)property13.baseName, (String)"uuidProp");
        Assert.assertEquals((String)property13.datatype, (String)"String");
        Assert.assertEquals((String)property13.baseType, (String)"String");
        Assert.assertEquals((String)property13.example, (String)"'046b6c7f-0b8a-43b9-b35d-6489e6daee91'");
        Assert.assertNull((Object)property13.defaultValue);
        Assert.assertTrue((boolean)property13.hasMore);
        Assert.assertTrue((boolean)property13.isPrimitiveType);
        Assert.assertTrue((boolean)property13.isNotContainer);
        CodegenProperty property14 = (CodegenProperty)vars.get(13);
        Assert.assertEquals((String)property14.name, (String)"byteArrProp");
        Assert.assertEquals((String)property14.baseName, (String)"byteArrProp");
        Assert.assertEquals((String)property14.datatype, (String)"Blob");
        Assert.assertEquals((String)property14.baseType, (String)"Blob");
        Assert.assertEquals((String)property14.example, (String)"EncodingUtil.base64Decode('VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu')");
        Assert.assertNull((Object)property14.defaultValue);
        Assert.assertTrue((boolean)property14.hasMore);
        Assert.assertTrue((boolean)property14.isPrimitiveType);
        Assert.assertTrue((boolean)property14.isNotContainer);
        Assert.assertTrue((boolean)property14.isByteArray);
        CodegenProperty property15 = (CodegenProperty)vars.get(14);
        Assert.assertEquals((String)property15.name, (String)"binaryProp");
        Assert.assertEquals((String)property15.baseName, (String)"binaryProp");
        Assert.assertEquals((String)property15.datatype, (String)"String");
        Assert.assertEquals((String)property15.baseType, (String)"String");
        Assert.assertEquals((String)property15.example, (String)"");
        Assert.assertNull((Object)property15.defaultValue);
        Assert.assertFalse((boolean)property15.hasMore);
        Assert.assertTrue((boolean)property15.isPrimitiveType);
        Assert.assertTrue((boolean)property15.isNotContainer);
        Assert.assertTrue((boolean)property15.isBinary);
    }
}

