/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.InlineModelResolver;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.util.Map;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class InlineModelResolverTest {
    @Test
    public void resolveInlineModelTestWithoutTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("address", (Property)new ObjectProperty()._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        ModelImpl user = (ModelImpl)swagger.getDefinitions().get("User");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertTrue((boolean)(user.getProperties().get("address") instanceof RefProperty));
        ModelImpl address = (ModelImpl)swagger.getDefinitions().get("User_address");
        AssertJUnit.assertNotNull((Object)address);
        AssertJUnit.assertNotNull(address.getProperties().get("city"));
        AssertJUnit.assertNotNull(address.getProperties().get("street"));
    }

    @Test
    public void resolveInlineModelTestWithTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("address", (Property)new ObjectProperty().title("UserAddressTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        ModelImpl user = (ModelImpl)swagger.getDefinitions().get("User");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertTrue((boolean)(user.getProperties().get("address") instanceof RefProperty));
        ModelImpl address = (ModelImpl)swagger.getDefinitions().get("UserAddressTitle");
        AssertJUnit.assertNotNull((Object)address);
        AssertJUnit.assertNotNull(address.getProperties().get("city"));
        AssertJUnit.assertNotNull(address.getProperties().get("street"));
    }

    @Test
    public void resolveInlineModel2EqualInnerModels() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("address", (Property)new ObjectProperty().title("UserAddressTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        swagger.addDefinition("AnotherUser", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("lastName", (Property)new StringProperty()).property("address", (Property)new ObjectProperty().title("UserAddressTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        ModelImpl user = (ModelImpl)swagger.getDefinitions().get("User");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertTrue((boolean)(user.getProperties().get("address") instanceof RefProperty));
        ModelImpl address = (ModelImpl)swagger.getDefinitions().get("UserAddressTitle");
        AssertJUnit.assertNotNull((Object)address);
        AssertJUnit.assertNotNull(address.getProperties().get("city"));
        AssertJUnit.assertNotNull(address.getProperties().get("street"));
        ModelImpl duplicateAddress = (ModelImpl)swagger.getDefinitions().get("UserAddressTitle_0");
        AssertJUnit.assertNull((Object)duplicateAddress);
    }

    @Test
    public void resolveInlineModel2DifferentInnerModelsWIthSameTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("address", (Property)new ObjectProperty().title("UserAddressTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        swagger.addDefinition("AnotherUser", (Model)new ModelImpl().name("AnotherUser").description("a common user").property("name", (Property)new StringProperty()).property("lastName", (Property)new StringProperty()).property("address", (Property)new ObjectProperty().title("UserAddressTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty()).property("apartment", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        ModelImpl user = (ModelImpl)swagger.getDefinitions().get("User");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertTrue((boolean)(user.getProperties().get("address") instanceof RefProperty));
        ModelImpl address = (ModelImpl)swagger.getDefinitions().get("UserAddressTitle");
        AssertJUnit.assertNotNull((Object)address);
        AssertJUnit.assertNotNull(address.getProperties().get("city"));
        AssertJUnit.assertNotNull(address.getProperties().get("street"));
        ModelImpl duplicateAddress = (ModelImpl)swagger.getDefinitions().get("UserAddressTitle_1");
        AssertJUnit.assertNotNull((Object)duplicateAddress);
        AssertJUnit.assertNotNull(duplicateAddress.getProperties().get("city"));
        AssertJUnit.assertNotNull(duplicateAddress.getProperties().get("street"));
        AssertJUnit.assertNotNull(duplicateAddress.getProperties().get("apartment"));
    }

    @Test
    public void testInlineResponseModel() throws Exception {
        Swagger swagger = new Swagger();
        ModelImpl responseSchema = new ModelImpl().type("object").property("name", (Property)new StringProperty());
        responseSchema.setVendorExtension("x-ext", (Object)"ext-prop");
        ModelImpl responseSchemaBaz = new ModelImpl().type("object").property("name", (Property)new StringProperty());
        responseSchemaBaz.setVendorExtension("x-ext", (Object)"ext-prop");
        swagger.path("/foo/bar", new Path().get(new Operation().response(200, new Response().description("it works!").responseSchema((Model)responseSchema)))).path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").responseSchema((Model)responseSchemaBaz))));
        new InlineModelResolver().flatten(swagger);
        Map responses = ((Path)swagger.getPaths().get("/foo/bar")).getGet().getResponses();
        Response response = (Response)responses.get("200");
        AssertJUnit.assertNotNull((Object)response);
        Property schema = response.getSchema();
        AssertJUnit.assertTrue((boolean)(schema instanceof RefProperty));
        ModelImpl model = (ModelImpl)swagger.getDefinitions().get("inline_response_200");
        AssertJUnit.assertTrue((model.getProperties().size() == 1 ? 1 : 0) != 0);
        AssertJUnit.assertNotNull(model.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(model.getProperties().get("name") instanceof StringProperty));
        AssertJUnit.assertEquals((int)1, (int)model.getVendorExtensions().size());
        AssertJUnit.assertEquals((Object)"ext-prop", model.getVendorExtensions().get("x-ext"));
    }

    @Test
    public void testInlineResponseModelWithTitle() throws Exception {
        Swagger swagger = new Swagger();
        String responseTitle = "GetBarResponse";
        ModelImpl responseSchema = new ModelImpl().type("object").property("name", (Property)new StringProperty());
        responseSchema.setTitle(responseTitle);
        ModelImpl responseSchemaBaz = new ModelImpl().type("object").property("name", (Property)new StringProperty());
        swagger.path("/foo/bar", new Path().get(new Operation().response(200, new Response().description("it works!").responseSchema((Model)responseSchema)))).path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").responseSchema((Model)responseSchemaBaz))));
        new InlineModelResolver().flatten(swagger);
        Map responses = ((Path)swagger.getPaths().get("/foo/bar")).getGet().getResponses();
        Response response = (Response)responses.get("200");
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertTrue((boolean)(response.getSchema() instanceof RefProperty));
        ModelImpl model = (ModelImpl)swagger.getDefinitions().get(responseTitle);
        AssertJUnit.assertTrue((model.getProperties().size() == 1 ? 1 : 0) != 0);
        AssertJUnit.assertNotNull(model.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(model.getProperties().get("name") instanceof StringProperty));
    }

    @Test
    public void resolveInlineArrayModelWithTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ArrayModel().items((Property)new ObjectProperty().title("InnerUserTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        Model model = (Model)swagger.getDefinitions().get("User");
        AssertJUnit.assertTrue((boolean)(model instanceof ArrayModel));
        Model user = (Model)swagger.getDefinitions().get("InnerUserTitle");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((String)"description", (String)user.getDescription());
    }

    @Test
    public void resolveInlineArrayModelWithoutTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ArrayModel().items((Property)new ObjectProperty()._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("street", (Property)new StringProperty()).property("city", (Property)new StringProperty())));
        new InlineModelResolver().flatten(swagger);
        Model model = (Model)swagger.getDefinitions().get("User");
        AssertJUnit.assertTrue((boolean)(model instanceof ArrayModel));
        Model user = (Model)swagger.getDefinitions().get("User_inner");
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((String)"description", (String)user.getDescription());
    }

    @Test
    public void resolveInlineBodyParameter() throws Exception {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ModelImpl().property("address", (Property)new ObjectProperty().property("street", (Property)new StringProperty())).property("name", (Property)new StringProperty())))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof RefModel));
        Model body = (Model)swagger.getDefinitions().get("body");
        AssertJUnit.assertTrue((boolean)(body instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)body;
        AssertJUnit.assertNotNull(impl.getProperties().get("address"));
    }

    @Test
    public void resolveInlineBodyParameterWithRequired() throws Exception {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ModelImpl().property("address", (Property)new ObjectProperty().property("street", (Property)new StringProperty().required(true)).required(true)).property("name", (Property)new StringProperty())))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof RefModel));
        Model body = (Model)swagger.getDefinitions().get("body");
        AssertJUnit.assertTrue((boolean)(body instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)body;
        AssertJUnit.assertNotNull(impl.getProperties().get("address"));
        Property addressProperty = (Property)impl.getProperties().get("address");
        AssertJUnit.assertTrue((boolean)(addressProperty instanceof RefProperty));
        AssertJUnit.assertTrue((boolean)addressProperty.getRequired());
        Model helloAddress = (Model)swagger.getDefinitions().get("hello_address");
        AssertJUnit.assertTrue((boolean)(helloAddress instanceof ModelImpl));
        ModelImpl addressImpl = (ModelImpl)helloAddress;
        AssertJUnit.assertNotNull((Object)addressImpl);
        Property streetProperty = (Property)addressImpl.getProperties().get("street");
        AssertJUnit.assertTrue((boolean)(streetProperty instanceof StringProperty));
        AssertJUnit.assertTrue((boolean)streetProperty.getRequired());
    }

    @Test
    public void resolveInlineBodyParameterWithTitle() throws Exception {
        Swagger swagger = new Swagger();
        ModelImpl addressModelItem = new ModelImpl();
        String addressModelName = "DetailedAddress";
        addressModelItem.setTitle(addressModelName);
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)addressModelItem.property("address", (Property)new ObjectProperty().property("street", (Property)new StringProperty())).property("name", (Property)new StringProperty())))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof RefModel));
        Model body = (Model)swagger.getDefinitions().get(addressModelName);
        AssertJUnit.assertTrue((boolean)(body instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)body;
        AssertJUnit.assertNotNull(impl.getProperties().get("address"));
    }

    @Test
    public void notResolveNonModelBodyParameter() throws Exception {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ModelImpl().type("string").format("binary")))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof ModelImpl));
        ModelImpl m = (ModelImpl)bp.getSchema();
        AssertJUnit.assertEquals((String)"string", (String)m.getType());
        AssertJUnit.assertEquals((String)"binary", (String)m.getFormat());
    }

    @Test
    public void resolveInlineArrayBodyParameter() throws Exception {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ArrayModel().items((Property)new ObjectProperty().property("address", (Property)new ObjectProperty().property("street", (Property)new StringProperty())))))));
        new InlineModelResolver().flatten(swagger);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/hello")).getGet().getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(param instanceof BodyParameter));
        BodyParameter bp = (BodyParameter)param;
        Model schema = bp.getSchema();
        AssertJUnit.assertTrue((boolean)(schema instanceof ArrayModel));
        ArrayModel am = (ArrayModel)schema;
        Property inner = am.getItems();
        AssertJUnit.assertTrue((boolean)(inner instanceof RefProperty));
        RefProperty rp = (RefProperty)inner;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/body");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"body");
        Model inline = (Model)swagger.getDefinitions().get("body");
        AssertJUnit.assertNotNull((Object)inline);
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        RefProperty rpAddress = (RefProperty)impl.getProperties().get("address");
        AssertJUnit.assertNotNull((Object)rpAddress);
        AssertJUnit.assertEquals((String)rpAddress.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rpAddress.get$ref(), (String)"#/definitions/hello_address");
        AssertJUnit.assertEquals((String)rpAddress.getSimpleRef(), (String)"hello_address");
        Model inlineProp = (Model)swagger.getDefinitions().get("hello_address");
        AssertJUnit.assertNotNull((Object)inlineProp);
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ModelImpl));
        ModelImpl implProp = (ModelImpl)inlineProp;
        AssertJUnit.assertNotNull(implProp.getProperties().get("street"));
        AssertJUnit.assertTrue((boolean)(implProp.getProperties().get("street") instanceof StringProperty));
    }

    @Test
    public void resolveInlineArrayResponse() throws Exception {
        Swagger swagger = new Swagger();
        ArrayProperty schema = new ArrayProperty().items((Property)new ObjectProperty().property("name", (Property)new StringProperty()).vendorExtension("x-ext", (Object)"ext-items")).vendorExtension("x-ext", (Object)"ext-prop");
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)schema))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertNotNull((Object)response.getSchema());
        Property responseProperty = response.getSchema();
        AssertJUnit.assertTrue((boolean)(responseProperty instanceof ArrayProperty));
        ArrayProperty ap = (ArrayProperty)responseProperty;
        AssertJUnit.assertEquals((int)1, (int)ap.getVendorExtensions().size());
        AssertJUnit.assertEquals((Object)"ext-prop", ap.getVendorExtensions().get("x-ext"));
        Property p = ap.getItems();
        AssertJUnit.assertNotNull((Object)p);
        RefProperty rp = (RefProperty)p;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/inline_response_200");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"inline_response_200");
        AssertJUnit.assertEquals((int)1, (int)rp.getVendorExtensions().size());
        AssertJUnit.assertEquals((Object)"ext-items", rp.getVendorExtensions().get("x-ext"));
        Model inline = (Model)swagger.getDefinitions().get("inline_response_200");
        AssertJUnit.assertNotNull((Object)inline);
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        AssertJUnit.assertNotNull(impl.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(impl.getProperties().get("name") instanceof StringProperty));
    }

    @Test
    public void resolveInlineArrayResponseWithTitle() throws Exception {
        Swagger swagger = new Swagger();
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)new ArrayProperty().items((Property)new ObjectProperty().title("FooBar").property("name", (Property)new StringProperty()))))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertNotNull((Object)response.getSchema());
        Property responseProperty = response.getSchema();
        AssertJUnit.assertTrue((boolean)(responseProperty instanceof ArrayProperty));
        ArrayProperty ap = (ArrayProperty)responseProperty;
        Property p = ap.getItems();
        AssertJUnit.assertNotNull((Object)p);
        RefProperty rp = (RefProperty)p;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/FooBar");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"FooBar");
        Model inline = (Model)swagger.getDefinitions().get("FooBar");
        AssertJUnit.assertNotNull((Object)inline);
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        AssertJUnit.assertNotNull(impl.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(impl.getProperties().get("name") instanceof StringProperty));
    }

    @Test
    public void testInlineMapResponse() throws Exception {
        Swagger swagger = new Swagger();
        MapProperty schema = new MapProperty();
        schema.setAdditionalProperties((Property)new StringProperty());
        schema.setVendorExtension("x-ext", (Object)"ext-prop");
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)schema))));
        new InlineModelResolver().flatten(swagger);
        Json.prettyPrint((Object)swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        Property property = response.getSchema();
        AssertJUnit.assertTrue((boolean)(property instanceof MapProperty));
        AssertJUnit.assertTrue((swagger.getDefinitions().size() == 0 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)1, (int)property.getVendorExtensions().size());
        AssertJUnit.assertEquals((Object)"ext-prop", property.getVendorExtensions().get("x-ext"));
    }

    @Test
    public void testInlineMapResponseWithObjectProperty() throws Exception {
        Swagger swagger = new Swagger();
        MapProperty schema = new MapProperty();
        schema.setAdditionalProperties((Property)new ObjectProperty().property("name", (Property)new StringProperty()));
        schema.setVendorExtension("x-ext", (Object)"ext-prop");
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)schema))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        Property property = response.getSchema();
        AssertJUnit.assertTrue((boolean)(property instanceof MapProperty));
        AssertJUnit.assertEquals((int)1, (int)property.getVendorExtensions().size());
        AssertJUnit.assertEquals((Object)"ext-prop", property.getVendorExtensions().get("x-ext"));
        AssertJUnit.assertTrue((swagger.getDefinitions().size() == 1 ? 1 : 0) != 0);
        Model inline = (Model)swagger.getDefinitions().get("inline_response_200");
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        AssertJUnit.assertNotNull(impl.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(impl.getProperties().get("name") instanceof StringProperty));
    }

    @Test
    public void testArrayResponse() {
        Swagger swagger = new Swagger();
        ArrayProperty schema = new ArrayProperty();
        schema.setItems((Property)new ObjectProperty().property("name", (Property)new StringProperty()));
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)schema))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        AssertJUnit.assertTrue((boolean)(response.getSchema() instanceof ArrayProperty));
        ArrayProperty am = (ArrayProperty)response.getSchema();
        Property items = am.getItems();
        AssertJUnit.assertTrue((boolean)(items instanceof RefProperty));
        RefProperty rp = (RefProperty)items;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/inline_response_200");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"inline_response_200");
        Model inline = (Model)swagger.getDefinitions().get("inline_response_200");
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        AssertJUnit.assertNotNull(impl.getProperties().get("name"));
        AssertJUnit.assertTrue((boolean)(impl.getProperties().get("name") instanceof StringProperty));
    }

    @Test
    public void testBasicInput() {
        Swagger swagger = new Swagger();
        ModelImpl user = new ModelImpl().property("name", (Property)new StringProperty());
        swagger.path("/foo/baz", new Path().post(new Operation().parameter((Parameter)new BodyParameter().name("myBody").schema((Model)new RefModel("User")))));
        swagger.addDefinition("User", (Model)user);
        new InlineModelResolver().flatten(swagger);
        Json.prettyPrint((Object)swagger);
    }

    @Test
    public void testArbitraryObjectBodyParam() {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ModelImpl()))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof ModelImpl));
        ModelImpl m = (ModelImpl)bp.getSchema();
        AssertJUnit.assertNull((Object)m.getType());
    }

    @Test
    public void testArbitraryObjectBodyParamInline() {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ModelImpl().property("arbitrary", (Property)new ObjectProperty())))));
        new InlineModelResolver().flatten(swagger);
        Operation operation = ((Path)swagger.getPaths().get("/hello")).getGet();
        BodyParameter bp = (BodyParameter)operation.getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(bp.getSchema() instanceof RefModel));
        Model body = (Model)swagger.getDefinitions().get("body");
        AssertJUnit.assertTrue((boolean)(body instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)body;
        Property p = (Property)impl.getProperties().get("arbitrary");
        AssertJUnit.assertNotNull((Object)p);
        AssertJUnit.assertTrue((boolean)(p instanceof ObjectProperty));
    }

    @Test
    public void testArbitraryObjectBodyParamWithArray() {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ArrayModel().items((Property)new ObjectProperty())))));
        new InlineModelResolver().flatten(swagger);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/hello")).getGet().getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(param instanceof BodyParameter));
        BodyParameter bp = (BodyParameter)param;
        Model schema = bp.getSchema();
        AssertJUnit.assertTrue((boolean)(schema instanceof ArrayModel));
        ArrayModel am = (ArrayModel)schema;
        Property inner = am.getItems();
        AssertJUnit.assertTrue((boolean)(inner instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inner;
        AssertJUnit.assertNotNull((Object)op);
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectBodyParamArrayInline() {
        Swagger swagger = new Swagger();
        swagger.path("/hello", new Path().get(new Operation().parameter((Parameter)new BodyParameter().name("body").schema((Model)new ArrayModel().items((Property)new ObjectProperty().property("arbitrary", (Property)new ObjectProperty()))))));
        new InlineModelResolver().flatten(swagger);
        Parameter param = (Parameter)((Path)swagger.getPaths().get("/hello")).getGet().getParameters().get(0);
        AssertJUnit.assertTrue((boolean)(param instanceof BodyParameter));
        BodyParameter bp = (BodyParameter)param;
        Model schema = bp.getSchema();
        AssertJUnit.assertTrue((boolean)(schema instanceof ArrayModel));
        ArrayModel am = (ArrayModel)schema;
        Property inner = am.getItems();
        AssertJUnit.assertTrue((boolean)(inner instanceof RefProperty));
        RefProperty rp = (RefProperty)inner;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/body");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"body");
        Model inline = (Model)swagger.getDefinitions().get("body");
        AssertJUnit.assertNotNull((Object)inline);
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        Property p = (Property)impl.getProperties().get("arbitrary");
        AssertJUnit.assertNotNull((Object)p);
        AssertJUnit.assertTrue((boolean)(p instanceof ObjectProperty));
    }

    @Test
    public void testArbitraryObjectResponse() {
        Swagger swagger = new Swagger();
        swagger.path("/foo/bar", new Path().get(new Operation().response(200, new Response().description("it works!").schema((Property)new ObjectProperty()))));
        new InlineModelResolver().flatten(swagger);
        Map responses = ((Path)swagger.getPaths().get("/foo/bar")).getGet().getResponses();
        Response response = (Response)responses.get("200");
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertTrue((boolean)(response.getSchema() instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)response.getSchema();
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectResponseArray() {
        Swagger swagger = new Swagger();
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().description("it works!").schema((Property)new ArrayProperty().items((Property)new ObjectProperty())))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        AssertJUnit.assertTrue((boolean)(response.getSchema() instanceof ArrayProperty));
        ArrayProperty am = (ArrayProperty)response.getSchema();
        Property items = am.getItems();
        AssertJUnit.assertTrue((boolean)(items instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)items;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectResponseArrayInline() {
        Swagger swagger = new Swagger();
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().vendorExtension("x-foo", (Object)"bar").description("it works!").schema((Property)new ArrayProperty().items((Property)new ObjectProperty().property("arbitrary", (Property)new ObjectProperty()))))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        AssertJUnit.assertNotNull((Object)response);
        AssertJUnit.assertNotNull((Object)response.getSchema());
        Property responseProperty = response.getSchema();
        AssertJUnit.assertTrue((boolean)(responseProperty instanceof ArrayProperty));
        ArrayProperty ap = (ArrayProperty)responseProperty;
        Property p = ap.getItems();
        AssertJUnit.assertNotNull((Object)p);
        RefProperty rp = (RefProperty)p;
        AssertJUnit.assertEquals((String)rp.getType(), (String)"ref");
        AssertJUnit.assertEquals((String)rp.get$ref(), (String)"#/definitions/inline_response_200");
        AssertJUnit.assertEquals((String)rp.getSimpleRef(), (String)"inline_response_200");
        Model inline = (Model)swagger.getDefinitions().get("inline_response_200");
        AssertJUnit.assertNotNull((Object)inline);
        AssertJUnit.assertTrue((boolean)(inline instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)inline;
        Property inlineProp = (Property)impl.getProperties().get("arbitrary");
        AssertJUnit.assertNotNull((Object)inlineProp);
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inlineProp;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectResponseMapInline() {
        Swagger swagger = new Swagger();
        MapProperty schema = new MapProperty();
        schema.setAdditionalProperties((Property)new ObjectProperty());
        swagger.path("/foo/baz", new Path().get(new Operation().response(200, new Response().description("it works!").schema((Property)schema))));
        new InlineModelResolver().flatten(swagger);
        Response response = (Response)((Path)swagger.getPaths().get("/foo/baz")).getGet().getResponses().get("200");
        Property property = response.getSchema();
        AssertJUnit.assertTrue((boolean)(property instanceof MapProperty));
        AssertJUnit.assertTrue((swagger.getDefinitions().size() == 0 ? 1 : 0) != 0);
        Property inlineProp = ((MapProperty)property).getAdditionalProperties();
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inlineProp;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectModelInline() {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ModelImpl().name("user").description("a common user").property("name", (Property)new StringProperty()).property("arbitrary", (Property)new ObjectProperty().title("title")._default("default").access("access").readOnly(false).required(true).description("description").name("name")));
        new InlineModelResolver().flatten(swagger);
        ModelImpl user = (ModelImpl)swagger.getDefinitions().get("User");
        AssertJUnit.assertNotNull((Object)user);
        Property inlineProp = (Property)user.getProperties().get("arbitrary");
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inlineProp;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectModelWithArrayInlineWithoutTitle() {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ArrayModel().items((Property)new ObjectProperty()._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("arbitrary", (Property)new ObjectProperty())));
        new InlineModelResolver().flatten(swagger);
        Model model = (Model)swagger.getDefinitions().get("User");
        AssertJUnit.assertTrue((boolean)(model instanceof ArrayModel));
        ArrayModel am = (ArrayModel)model;
        Property inner = am.getItems();
        AssertJUnit.assertTrue((boolean)(inner instanceof RefProperty));
        ModelImpl userInner = (ModelImpl)swagger.getDefinitions().get("User_inner");
        AssertJUnit.assertNotNull((Object)userInner);
        Property inlineProp = (Property)userInner.getProperties().get("arbitrary");
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inlineProp;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testArbitraryObjectModelWithArrayInlineWithTitle() {
        Swagger swagger = new Swagger();
        swagger.addDefinition("User", (Model)new ArrayModel().items((Property)new ObjectProperty().title("InnerUserTitle")._default("default").access("access").readOnly(false).required(true).description("description").name("name").property("arbitrary", (Property)new ObjectProperty())));
        new InlineModelResolver().flatten(swagger);
        Model model = (Model)swagger.getDefinitions().get("User");
        AssertJUnit.assertTrue((boolean)(model instanceof ArrayModel));
        ArrayModel am = (ArrayModel)model;
        Property inner = am.getItems();
        AssertJUnit.assertTrue((boolean)(inner instanceof RefProperty));
        ModelImpl userInner = (ModelImpl)swagger.getDefinitions().get("InnerUserTitle");
        AssertJUnit.assertNotNull((Object)userInner);
        Property inlineProp = (Property)userInner.getProperties().get("arbitrary");
        AssertJUnit.assertTrue((boolean)(inlineProp instanceof ObjectProperty));
        ObjectProperty op = (ObjectProperty)inlineProp;
        AssertJUnit.assertNull((Object)op.getProperties());
    }

    @Test
    public void testEmptyExampleOnStrinngTypeModels() {
        Swagger swagger = new Swagger();
        RefProperty refProperty = new RefProperty();
        refProperty.set$ref("#/definitions/Test");
        swagger.path("/hello", new Path().get(new Operation().response(200, new Response().schema((Property)new ArrayProperty().items((Property)refProperty)))));
        swagger.addDefinition("Test", (Model)new ModelImpl().example((Object)"").type("string"));
        new InlineModelResolver().flatten(swagger);
    }
}

