/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.swagger.codegen.examples.ExampleGenerator;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExampleGeneratorTest {
    @Test(description="check handling of recursive models")
    public void recursiveModelsTest() {
        String JSON = "application/json";
        String XML = "application/xml";
        String nodeType = "Node";
        RefProperty ref = new RefProperty("Node");
        ModelImpl node = new ModelImpl().name("Node").property("name", (Property)new StringProperty()).property("parent", (Property)ref).property("children", (Property)new ArrayProperty((Property)ref)).property("wrappedChildren", (Property)new ArrayProperty((Property)ref).xml(new Xml().wrapped(Boolean.valueOf(true))));
        String pairType = "Pair";
        ModelImpl pair = new ModelImpl().name("Pair");
        for (Map.Entry item : ImmutableMap.of((Object)"first", (Object)"First", (Object)"second", (Object)"Second").entrySet()) {
            RefProperty property = new RefProperty("Node");
            property.setXml(new Xml().name((String)item.getValue()));
            pair.property((String)item.getKey(), (Property)property);
        }
        HashSet types = Sets.newHashSet();
        List<String> expectedTypes = Arrays.asList("application/json", "application/xml");
        ExampleGenerator eg = new ExampleGenerator((Map)ImmutableMap.of((Object)"Node", (Object)node, (Object)"Pair", (Object)pair));
        for (Map item : eg.generate(null, expectedTypes, (Property)new RefProperty("Pair"))) {
            String example = (String)item.get("example");
            String contentType = (String)item.get("contentType");
            if ("application/xml".equals(contentType)) {
                types.add("application/xml");
                Assert.assertEquals((String)example, (String)"<Pair>\n  <Node>\n    <name>aeiou</name>\n    <wrappedChildren>\n    </wrappedChildren>\n  </Node>\n  <Node>\n    <name>aeiou</name>\n    <wrappedChildren>\n    </wrappedChildren>\n  </Node>\n</Pair>");
                continue;
            }
            if (!"application/json".equals(contentType)) continue;
            types.add("application/json");
            Assert.assertNotNull((Object)example);
        }
        Assert.assertEqualsNoOrder((Object[])types.toArray(new String[types.size()]), (Object[])expectedTypes.toArray(new String[expectedTypes.size()]));
    }
}

