/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.config.CodegenConfigurator;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.codegen.languages.SpringCodegen;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.parser.SwaggerParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultGeneratorTest {
    private static final String TEST_SKIP_OVERWRITE = "testSkipOverwrite";
    private static final String POM_FILE = "pom.xml";
    private static final String MODEL_ORDER_FILE = "/src/main/java/io/swagger/client/model/Order.java";
    private static final String API_CLIENT_FILE = "/src/main/java/io/swagger/client/ApiClient.java";
    private static final String BUILD_GRADLE_FILE = "build.gradle";
    private static final String LIBRARY_COMMENT = "//overloaded template file within library folder to add this comment";
    private static final String TEMPLATE_COMMENT = "//overloaded main template file to add this comment";
    private static final String MODEL_DEFAULT_API_FILE = "/src/main/java/io/swagger/client/api/DefaultApi.java";
    public TemporaryFolder folder = new TemporaryFolder();

    @BeforeMethod
    public void setUp() throws Exception {
        this.folder.create();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.folder.delete();
    }

    @Test
    public void testNotNullJacksonAnnotationJava_True() throws IOException {
        File output = this.folder.getRoot();
        CodegenConfigurator codegenConfigurator = new CodegenConfigurator();
        codegenConfigurator.setInputSpec("src/test/resources/2_0/allOfTest.yaml");
        codegenConfigurator.setOutputDir(output.getAbsolutePath());
        codegenConfigurator.setLang("java");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put("dateLibrary", "java8");
        additionalProperties.put("apiTests", false);
        additionalProperties.put("hideGenerationTimestamp", true);
        additionalProperties.put("invokerPackage", "com.mycompany.generated.client");
        additionalProperties.put("modelPackage", "com.mycompany.generated.client.model");
        additionalProperties.put("apiPackage", "com.mycompany.generated.client.api");
        additionalProperties.put("notNullJacksonAnnotation", true);
        codegenConfigurator.setAdditionalProperties(additionalProperties);
        HashMap<String, String> importMapping = new HashMap<String, String>();
        importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        importMapping.put("LocalTime", "java.time.LocalTime");
        importMapping.put("DayOfWeek", "java.time.DayOfWeek");
        importMapping.put("Duration", "java.time.Duration");
        importMapping.put("ChronoUnit", "java.time.temporal.ChronoUnit");
        importMapping.put("Currency", "java.util.Currency");
        importMapping.put("LocalDate", "java.time.LocalDate");
        importMapping.put("Locale", "java.util.Locale");
        importMapping.put("ZoneId", "java.time.ZoneId");
        codegenConfigurator.setImportMappings(importMapping);
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apiTests", "false");
        generator.setGeneratorPropertyDefault("apiDocs", "false");
        generator.opts(codegenConfigurator.toClientOptInput()).generate();
        File model = new File(output, "src/main/java/com/mycompany/generated/client/model/ModelOne.java");
        org.testng.Assert.assertTrue((boolean)model.exists());
        org.testng.Assert.assertTrue((boolean)FileUtils.readFileToString((File)model).contains("@JsonInclude(JsonInclude.Include.NON_NULL)"));
        org.testng.Assert.assertTrue((boolean)FileUtils.readFileToString((File)model).contains("import com.fasterxml.jackson.annotation.JsonInclude;"));
    }

    @Test
    public void testNotNullJacksonAnnotationJava_False() throws IOException {
        File output = this.folder.getRoot();
        CodegenConfigurator codegenConfigurator = new CodegenConfigurator();
        codegenConfigurator.setInputSpec("src/test/resources/2_0/allOfTest.yaml");
        codegenConfigurator.setOutputDir(output.getAbsolutePath());
        codegenConfigurator.setLang("java");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put("dateLibrary", "java8");
        additionalProperties.put("library", "feign");
        additionalProperties.put("apiTests", false);
        additionalProperties.put("hideGenerationTimestamp", true);
        additionalProperties.put("invokerPackage", "com.mycompany.generated.client");
        additionalProperties.put("modelPackage", "com.mycompany.generated.client.model");
        additionalProperties.put("apiPackage", "com.mycompany.generated.client.api");
        additionalProperties.put("notNullJacksonAnnotation", false);
        codegenConfigurator.setAdditionalProperties(additionalProperties);
        HashMap<String, String> importMapping = new HashMap<String, String>();
        importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        importMapping.put("LocalTime", "java.time.LocalTime");
        importMapping.put("DayOfWeek", "java.time.DayOfWeek");
        importMapping.put("Duration", "java.time.Duration");
        importMapping.put("ChronoUnit", "java.time.temporal.ChronoUnit");
        importMapping.put("Currency", "java.util.Currency");
        importMapping.put("LocalDate", "java.time.LocalDate");
        importMapping.put("Locale", "java.util.Locale");
        importMapping.put("ZoneId", "java.time.ZoneId");
        codegenConfigurator.setImportMappings(importMapping);
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apiTests", "false");
        generator.setGeneratorPropertyDefault("apiDocs", "false");
        generator.opts(codegenConfigurator.toClientOptInput()).generate();
        File model = new File(output, "src/main/java/com/mycompany/generated/client/model/ModelOne.java");
        org.testng.Assert.assertTrue((boolean)model.exists());
        org.testng.Assert.assertFalse((boolean)FileUtils.readFileToString((File)model).contains("@JsonInclude(JsonInclude.Include.NON_NULL)"));
        org.testng.Assert.assertFalse((boolean)FileUtils.readFileToString((File)model).contains("import com.fasterxml.jackson.annotation.JsonInclude;"));
    }

    @Test
    public void testNotNullJacksonAnnotationSpring_True() throws IOException {
        File output = this.folder.getRoot();
        CodegenConfigurator codegenConfigurator = new CodegenConfigurator();
        codegenConfigurator.setInputSpec("src/test/resources/2_0/allOfTest.yaml");
        codegenConfigurator.setOutputDir(output.getAbsolutePath());
        codegenConfigurator.setLang("spring");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put("dateLibrary", "java8");
        additionalProperties.put("apiTests", false);
        additionalProperties.put("hideGenerationTimestamp", true);
        additionalProperties.put("invokerPackage", "com.mycompany.generated.client");
        additionalProperties.put("modelPackage", "com.mycompany.generated.client.model");
        additionalProperties.put("apiPackage", "com.mycompany.generated.client.api");
        additionalProperties.put("notNullJacksonAnnotation", true);
        codegenConfigurator.setAdditionalProperties(additionalProperties);
        HashMap<String, String> importMapping = new HashMap<String, String>();
        importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        importMapping.put("LocalTime", "java.time.LocalTime");
        importMapping.put("DayOfWeek", "java.time.DayOfWeek");
        importMapping.put("Duration", "java.time.Duration");
        importMapping.put("ChronoUnit", "java.time.temporal.ChronoUnit");
        importMapping.put("Currency", "java.util.Currency");
        importMapping.put("LocalDate", "java.time.LocalDate");
        importMapping.put("Locale", "java.util.Locale");
        importMapping.put("ZoneId", "java.time.ZoneId");
        codegenConfigurator.setImportMappings(importMapping);
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apiTests", "false");
        generator.setGeneratorPropertyDefault("apiDocs", "false");
        generator.opts(codegenConfigurator.toClientOptInput()).generate();
        File model = new File(output, "src/main/java/com/mycompany/generated/client/model/ModelOne.java");
        org.testng.Assert.assertTrue((boolean)model.exists());
        org.testng.Assert.assertTrue((boolean)FileUtils.readFileToString((File)model).contains("@JsonInclude(JsonInclude.Include.NON_NULL)"));
        org.testng.Assert.assertTrue((boolean)FileUtils.readFileToString((File)model).contains("import com.fasterxml.jackson.annotation.JsonInclude;"));
    }

    @Test
    public void testNotNullJacksonAnnotationSpring_False() throws IOException {
        File output = this.folder.getRoot();
        CodegenConfigurator codegenConfigurator = new CodegenConfigurator();
        codegenConfigurator.setInputSpec("src/test/resources/2_0/allOfTest.yaml");
        codegenConfigurator.setOutputDir(output.getAbsolutePath());
        codegenConfigurator.setLang("spring");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put("dateLibrary", "java8");
        additionalProperties.put("library", "spring-boot");
        additionalProperties.put("apiTests", false);
        additionalProperties.put("hideGenerationTimestamp", true);
        additionalProperties.put("invokerPackage", "com.mycompany.generated.client");
        additionalProperties.put("modelPackage", "com.mycompany.generated.client.model");
        additionalProperties.put("apiPackage", "com.mycompany.generated.client.api");
        additionalProperties.put("notNullJacksonAnnotation", false);
        codegenConfigurator.setAdditionalProperties(additionalProperties);
        HashMap<String, String> importMapping = new HashMap<String, String>();
        importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        importMapping.put("LocalTime", "java.time.LocalTime");
        importMapping.put("DayOfWeek", "java.time.DayOfWeek");
        importMapping.put("Duration", "java.time.Duration");
        importMapping.put("ChronoUnit", "java.time.temporal.ChronoUnit");
        importMapping.put("Currency", "java.util.Currency");
        importMapping.put("LocalDate", "java.time.LocalDate");
        importMapping.put("Locale", "java.util.Locale");
        importMapping.put("ZoneId", "java.time.ZoneId");
        codegenConfigurator.setImportMappings(importMapping);
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apiTests", "false");
        generator.setGeneratorPropertyDefault("apiDocs", "false");
        generator.opts(codegenConfigurator.toClientOptInput()).generate();
        File model = new File(output, "src/main/java/com/mycompany/generated/client/model/ModelOne.java");
        org.testng.Assert.assertTrue((boolean)model.exists());
        org.testng.Assert.assertFalse((boolean)FileUtils.readFileToString((File)model).contains("@JsonInclude(JsonInclude.Include.NON_NULL)"));
        org.testng.Assert.assertFalse((boolean)FileUtils.readFileToString((File)model).contains("import com.fasterxml.jackson.annotation.JsonInclude;"));
    }

    @Test
    public void testSecurityWithoutGlobal() throws Exception {
        CodegenSecurity petstoreAuth;
        CodegenSecurity apiKey;
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/petstore.json");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator gen = new DefaultGenerator();
        gen.opts(clientOptInput);
        Map paths = gen.processPaths(swagger.getPaths());
        CodegenOperation getPetById = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "getPetById");
        org.testng.Assert.assertEquals((int)getPetById.authMethods.size(), (int)2);
        CodegenSecurity cs = (CodegenSecurity)getPetById.authMethods.get(0);
        if ("api_key".equals(cs.name)) {
            apiKey = cs;
            petstoreAuth = (CodegenSecurity)getPetById.authMethods.get(1);
        } else {
            petstoreAuth = cs;
            apiKey = (CodegenSecurity)getPetById.authMethods.get(1);
        }
        org.testng.Assert.assertEquals((String)petstoreAuth.name, (String)"petstore_auth");
        org.testng.Assert.assertEquals((String)petstoreAuth.type, (String)"oauth2");
        org.testng.Assert.assertEquals((String)apiKey.name, (String)"api_key");
        org.testng.Assert.assertEquals((String)apiKey.type, (String)"apiKey");
        CodegenOperation updatePetWithForm = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "updatePetWithForm");
        org.testng.Assert.assertEquals((int)updatePetWithForm.authMethods.size(), (int)1);
        petstoreAuth = (CodegenSecurity)updatePetWithForm.authMethods.iterator().next();
        org.testng.Assert.assertEquals((String)petstoreAuth.name, (String)"petstore_auth");
        org.testng.Assert.assertEquals((String)petstoreAuth.type, (String)"oauth2");
        CodegenOperation loginUser = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "loginUser");
        org.testng.Assert.assertNull((Object)loginUser.authMethods);
    }

    @Test
    public void testSecurityWithGlobal() throws Exception {
        CodegenSecurity apiKey2;
        CodegenSecurity petstoreAuth;
        CodegenSecurity apiKey;
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/globalSecurity.json");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator gen = new DefaultGenerator();
        gen.opts(clientOptInput);
        Map paths = gen.processPaths(swagger.getPaths());
        CodegenOperation getPetById = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "getPetById");
        org.testng.Assert.assertEquals((int)getPetById.authMethods.size(), (int)2);
        CodegenSecurity cs = (CodegenSecurity)getPetById.authMethods.get(0);
        if ("api_key".equals(cs.name)) {
            apiKey = cs;
            petstoreAuth = (CodegenSecurity)getPetById.authMethods.get(1);
        } else {
            petstoreAuth = cs;
            apiKey = (CodegenSecurity)getPetById.authMethods.get(1);
        }
        org.testng.Assert.assertEquals((String)petstoreAuth.type, (String)"oauth2");
        org.testng.Assert.assertEquals((String)petstoreAuth.name, (String)"petstore_auth");
        org.testng.Assert.assertEquals((String)apiKey.name, (String)"api_key");
        org.testng.Assert.assertEquals((String)apiKey.type, (String)"apiKey");
        CodegenOperation updatePetWithForm = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "updatePetWithForm");
        org.testng.Assert.assertEquals((int)updatePetWithForm.authMethods.size(), (int)1);
        petstoreAuth = (CodegenSecurity)updatePetWithForm.authMethods.iterator().next();
        org.testng.Assert.assertEquals((String)petstoreAuth.name, (String)"petstore_auth");
        org.testng.Assert.assertEquals((String)petstoreAuth.type, (String)"oauth2");
        CodegenOperation loginUser = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "loginUser");
        org.testng.Assert.assertEquals((int)loginUser.authMethods.size(), (int)2);
        cs = (CodegenSecurity)loginUser.authMethods.get(0);
        if ("api_key".equals(cs.name)) {
            apiKey = cs;
            petstoreAuth = (CodegenSecurity)loginUser.authMethods.get(1);
        } else {
            petstoreAuth = cs;
            apiKey = (CodegenSecurity)loginUser.authMethods.get(1);
        }
        org.testng.Assert.assertEquals((String)apiKey.name, (String)"api_key");
        org.testng.Assert.assertEquals((String)apiKey.type, (String)"apiKey");
        org.testng.Assert.assertEquals((String)petstoreAuth.name, (String)"petstore_auth");
        org.testng.Assert.assertEquals((String)petstoreAuth.type, (String)"oauth2");
        CodegenOperation logoutUser = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "logoutUser");
        org.testng.Assert.assertNull((Object)logoutUser.authMethods);
        CodegenOperation getUserByName = DefaultGeneratorTest.findCodegenOperationByOperationId(paths, "getUserByName");
        org.testng.Assert.assertEquals((int)getUserByName.authMethods.size(), (int)2);
        cs = (CodegenSecurity)getUserByName.authMethods.get(0);
        if ("api_key".equals(cs.name)) {
            apiKey = cs;
            apiKey2 = (CodegenSecurity)getUserByName.authMethods.get(1);
        } else {
            apiKey2 = cs;
            apiKey = (CodegenSecurity)getUserByName.authMethods.get(1);
        }
        org.testng.Assert.assertEquals((String)apiKey.name, (String)"api_key");
        org.testng.Assert.assertEquals((String)apiKey.type, (String)"apiKey");
        org.testng.Assert.assertEquals((String)apiKey2.name, (String)"api_key2");
        org.testng.Assert.assertEquals((String)apiKey2.type, (String)"apiKey");
    }

    @Test
    public void testSkipOverwrite() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/petstore.json");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setLibrary("jersey1");
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        new DefaultGenerator().opts(clientOptInput).generate();
        File order = new File(output, MODEL_ORDER_FILE);
        org.testng.Assert.assertTrue((boolean)order.exists());
        DefaultGeneratorTest.changeContent(order);
        new DefaultGenerator().opts(clientOptInput).generate();
        org.testng.Assert.assertTrue((!TEST_SKIP_OVERWRITE.equals(FileUtils.readFileToString((File)order, (Charset)StandardCharsets.UTF_8)) ? 1 : 0) != 0);
        DefaultGeneratorTest.changeContent(order);
        File pom = new File(output, POM_FILE);
        if (pom.exists() && !pom.delete()) {
            Assert.fail((String)"it doesn't delete");
        }
        codegenConfig.setSkipOverwrite(true);
        new DefaultGenerator().opts(clientOptInput).generate();
        org.testng.Assert.assertEquals((String)FileUtils.readFileToString((File)order, (Charset)StandardCharsets.UTF_8), (String)TEST_SKIP_OVERWRITE);
    }

    @Test
    public void testIssue9132() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/issue-9132.yaml");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setLibrary("jersey1");
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        new DefaultGenerator().opts(clientOptInput).generate();
        File defaultApi = new File(output, MODEL_DEFAULT_API_FILE);
        org.testng.Assert.assertTrue((boolean)defaultApi.exists());
    }

    @Test
    public void testIssue9725() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/ticket-9725.json");
        SpringCodegen codegenConfig = new SpringCodegen();
        codegenConfig.setLibrary("spring-cloud");
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        new DefaultGenerator().opts(clientOptInput).generate();
        File defaultApi = new File(output, "src/main/java/io/swagger/api/DefaultApi.java");
        org.testng.Assert.assertTrue((boolean)defaultApi.exists());
        org.testng.Assert.assertTrue((boolean)this.containsSearchStrings(defaultApi, "ResponseEntity<List<GetMarketsRegionIdOrders200Ok>>"));
    }

    @Test
    public void testIssue9725Map() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/ticket-9725-map.json");
        SpringCodegen codegenConfig = new SpringCodegen();
        codegenConfig.setLibrary("spring-cloud");
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        new DefaultGenerator().opts(clientOptInput).generate();
        File defaultApi = new File(output, "src/main/java/io/swagger/api/DefaultApi.java");
        org.testng.Assert.assertTrue((boolean)defaultApi.exists());
        org.testng.Assert.assertTrue((boolean)this.containsSearchStrings(defaultApi, "ResponseEntity<Map<String, GetMarketsRegionIdOrders200Ok>>"));
    }

    @Test
    public void testRelativeRefs() throws IOException {
        File output = this.folder.getRoot();
        CodegenConfigurator codegenConfigurator = new CodegenConfigurator();
        codegenConfigurator.setInputSpec("src/test/resources/2_0/relative-ref/nested/directory/main/relative-refs.yml");
        codegenConfigurator.setOutputDir(output.getAbsolutePath());
        codegenConfigurator.setLang("java");
        HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
        additionalProperties.put("dateLibrary", "java8");
        additionalProperties.put("library", "feign");
        additionalProperties.put("apiTests", false);
        additionalProperties.put("hideGenerationTimestamp", true);
        additionalProperties.put("invokerPackage", "com.mycompany.generated.client");
        additionalProperties.put("modelPackage", "com.mycompany.generated.client.model");
        additionalProperties.put("apiPackage", "com.mycompany.generated.client.api");
        codegenConfigurator.setAdditionalProperties(additionalProperties);
        HashMap<String, String> importMapping = new HashMap<String, String>();
        importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        importMapping.put("LocalTime", "java.time.LocalTime");
        importMapping.put("DayOfWeek", "java.time.DayOfWeek");
        importMapping.put("Duration", "java.time.Duration");
        importMapping.put("ChronoUnit", "java.time.temporal.ChronoUnit");
        importMapping.put("Currency", "java.util.Currency");
        importMapping.put("LocalDate", "java.time.LocalDate");
        importMapping.put("Locale", "java.util.Locale");
        importMapping.put("ZoneId", "java.time.ZoneId");
        codegenConfigurator.setImportMappings(importMapping);
        DefaultGenerator generator = new DefaultGenerator();
        generator.setGeneratorPropertyDefault("modelTests", "false");
        generator.setGeneratorPropertyDefault("modelDocs", "false");
        generator.setGeneratorPropertyDefault("apiTests", "false");
        generator.setGeneratorPropertyDefault("apiDocs", "false");
        generator.opts(codegenConfigurator.toClientOptInput()).generate();
        File defaultApi = new File(output, "src/main/java/com/mycompany/generated/client/api/DefaultApi.java");
        org.testng.Assert.assertTrue((boolean)defaultApi.exists());
        org.testng.Assert.assertFalse((boolean)this.containsSearchStrings(defaultApi, "RelativeRefnesteddirectorydefinitionsphotosYmldefinitionsPhoto"));
    }

    private boolean containsSearchStrings(File file, String ... search) throws IOException {
        for (String line : Files.readAllLines(file.toPath(), Charset.defaultCharset())) {
            if (!StringUtils.containsAny((CharSequence)line, (CharSequence[])search)) continue;
            return true;
        }
        return false;
    }

    private boolean containsOverloadedComments(File file, String ... search) throws IOException {
        return this.containsSearchStrings(file, search);
    }

    @Test
    public void testOverloadingTemplateFiles() throws Exception {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/petstore.json");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setLibrary("jersey2");
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        new DefaultGenerator().opts(clientOptInput).generate();
        File order = new File(output, MODEL_ORDER_FILE);
        org.testng.Assert.assertTrue((boolean)order.exists());
        org.testng.Assert.assertFalse((boolean)this.containsOverloadedComments(order, TEMPLATE_COMMENT, LIBRARY_COMMENT));
        File gradle = new File(output, BUILD_GRADLE_FILE);
        org.testng.Assert.assertTrue((boolean)gradle.exists());
        org.testng.Assert.assertFalse((boolean)this.containsOverloadedComments(gradle, TEMPLATE_COMMENT, LIBRARY_COMMENT));
        File apiClient = new File(output, API_CLIENT_FILE);
        org.testng.Assert.assertTrue((boolean)apiClient.exists());
        org.testng.Assert.assertFalse((boolean)this.containsOverloadedComments(apiClient, TEMPLATE_COMMENT, LIBRARY_COMMENT));
        codegenConfig.additionalProperties().put("templateDir", "src/test/resources/2_0/templates/Java");
        new DefaultGenerator().opts(clientOptInput).generate();
        org.testng.Assert.assertTrue((boolean)order.exists());
        org.testng.Assert.assertTrue((boolean)this.containsOverloadedComments(order, TEMPLATE_COMMENT));
        org.testng.Assert.assertTrue((boolean)gradle.exists());
        org.testng.Assert.assertTrue((boolean)this.containsOverloadedComments(gradle, LIBRARY_COMMENT));
        org.testng.Assert.assertTrue((boolean)apiClient.exists());
        org.testng.Assert.assertTrue((boolean)this.containsOverloadedComments(apiClient, LIBRARY_COMMENT));
    }

    @Test
    public void testGenerateUniqueOperationIds() {
        File output = this.folder.getRoot();
        Swagger swagger = new SwaggerParser().read("src/test/resources/2_0/duplicateOperationIds.yaml");
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        generator.opts(clientOptInput);
        Map paths = generator.processPaths(swagger.getPaths());
        HashSet<String> opIds = new HashSet<String>();
        for (String path : paths.keySet()) {
            List ops = (List)paths.get(path);
            for (CodegenOperation op : ops) {
                org.testng.Assert.assertFalse((boolean)opIds.contains(op.operationId));
                opIds.add(op.operationId);
            }
        }
    }

    @Test
    public void testResolveTagsAgainstSwaggerTagsDefinition() {
        File output = this.folder.getRoot();
        String spec = "swagger: '2.0'\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\ntags:\n  - name: pet\n    description: Everything about your Pets\n    externalDocs:\n      description: Find out more\n      url: 'http://swagger.io'\n    x-vendor-ext: 'tag'\n  - name: store\n    description: Access to Petstore orders\n  - name: user\n    description: Operations about user\n    externalDocs:\n      x-vendor-ext: 'foo'\npaths:\n  /pet:\n    get:\n      tags:\n        - pet\n        - store\n        - user\n      responses:\n        '200':\n          description: OK";
        ArrayList<Tag> expectedTags = new ArrayList<Tag>();
        expectedTags.add(new Tag().name("pet").description("Everything about your Pets").externalDocs(new ExternalDocs().description("Find out more").url("http://swagger.io")));
        expectedTags.add(new Tag().name("store").description("Access to Petstore orders"));
        expectedTags.add(new Tag().name("user").description("Operations about user").externalDocs(new ExternalDocs()));
        ((Tag)expectedTags.get(0)).getVendorExtensions().put("x-vendor-ext", "tag");
        ((Tag)expectedTags.get(2)).getExternalDocs().getVendorExtensions().put("x-vendor-ext", "foo");
        Swagger swagger = new SwaggerParser().readWithInfo(spec).getSwagger();
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        generator.opts(clientOptInput);
        Map paths = generator.processPaths(swagger.getPaths());
        org.testng.Assert.assertEquals((int)3, (int)paths.size());
        List<String> sanitizedTags = Arrays.asList("Pet", "Store", "User");
        for (String tag : sanitizedTags) {
            List operations = (List)paths.get(tag);
            org.testng.Assert.assertNotNull((Object)operations);
            for (CodegenOperation operation : operations) {
                this.assertOperationHasTags(operation, expectedTags);
            }
        }
    }

    @Test
    public void testResolveTagsNoSwaggerTagsDefinition() {
        File output = this.folder.getRoot();
        String spec = "swagger: '2.0'\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\npaths:\n  /pet:\n    get:\n      tags:\n        - pet\n        - store\n        - user\n      responses:\n        '200':\n          description: OK";
        ArrayList<Tag> expectedTags = new ArrayList<Tag>();
        expectedTags.add(new Tag().name("pet"));
        expectedTags.add(new Tag().name("store"));
        expectedTags.add(new Tag().name("user"));
        Swagger swagger = new SwaggerParser().readWithInfo(spec).getSwagger();
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        generator.opts(clientOptInput);
        Map paths = generator.processPaths(swagger.getPaths());
        org.testng.Assert.assertEquals((int)3, (int)paths.size());
        List<String> sanitizedTags = Arrays.asList("Pet", "Store", "User");
        for (String tag : sanitizedTags) {
            List operations = (List)paths.get(tag);
            org.testng.Assert.assertNotNull((Object)operations);
            for (CodegenOperation operation : operations) {
                this.assertOperationHasTags(operation, expectedTags);
            }
        }
    }

    @Test
    public void testResolveTagsNoTagsDefined() {
        File output = this.folder.getRoot();
        String spec = "swagger: '2.0'\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\npaths:\n  /pet:\n    get:\n      responses:\n        '200':\n          description: OK";
        ArrayList<Tag> expectedTags = new ArrayList<Tag>();
        expectedTags.add(new Tag().name("default"));
        Swagger swagger = new SwaggerParser().readWithInfo(spec).getSwagger();
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        generator.opts(clientOptInput);
        Map paths = generator.processPaths(swagger.getPaths());
        org.testng.Assert.assertEquals((int)1, (int)paths.size());
        List<String> sanitizedTags = Collections.singletonList("Default");
        for (String tag : sanitizedTags) {
            List operations = (List)paths.get(tag);
            org.testng.Assert.assertNotNull((Object)operations);
            for (CodegenOperation operation : operations) {
                this.assertOperationHasTags(operation, expectedTags);
            }
        }
    }

    @Test
    public void testResolveTagNotDefinedInSwaggerTagsDefinition() {
        File output = this.folder.getRoot();
        String spec = "swagger: '2.0'\ninfo:\n  version: 1.0.0\n  title: Swagger Petstore\ntags:\n  - name: pet\n    description: Everything about your Pets\npaths:\n  /pet:\n    get:\n      tags:\n        - pet\n        - store\n        - user\n      responses:\n        '200':\n          description: OK";
        ArrayList<Tag> expectedTags = new ArrayList<Tag>();
        expectedTags.add(new Tag().name("pet").description("Everything about your Pets"));
        expectedTags.add(new Tag().name("store"));
        expectedTags.add(new Tag().name("user"));
        Swagger swagger = new SwaggerParser().readWithInfo(spec).getSwagger();
        JavaClientCodegen codegenConfig = new JavaClientCodegen();
        codegenConfig.setOutputDir(output.getAbsolutePath());
        ClientOptInput clientOptInput = new ClientOptInput().opts(new ClientOpts()).swagger(swagger).config((CodegenConfig)codegenConfig);
        DefaultGenerator generator = new DefaultGenerator();
        generator.opts(clientOptInput);
        Map paths = generator.processPaths(swagger.getPaths());
        org.testng.Assert.assertEquals((int)3, (int)paths.size());
        List<String> sanitizedTags = Arrays.asList("Pet", "Store", "User");
        for (String tag : sanitizedTags) {
            List operations = (List)paths.get(tag);
            org.testng.Assert.assertNotNull((Object)operations);
            for (CodegenOperation operation : operations) {
                this.assertOperationHasTags(operation, expectedTags);
            }
        }
    }

    private void assertOperationHasTags(CodegenOperation op, List<Tag> expectedTags) {
        org.testng.Assert.assertNotNull((Object)op.tags);
        org.testng.Assert.assertEquals((int)op.tags.size(), (int)expectedTags.size());
        for (Tag tag : expectedTags) {
            Tag foundTag = null;
            for (Tag opTag : op.tags) {
                if (!tag.getName().equals(opTag.getName())) continue;
                foundTag = opTag;
                break;
            }
            if (foundTag == null) {
                Assert.fail((String)("Expected tag '" + tag.getName() + "' was not found on operation " + op.operationId));
            }
            org.testng.Assert.assertEquals((Object)tag, foundTag);
            if (!tag.getVendorExtensions().isEmpty()) {
                org.testng.Assert.assertEquals((Map)tag.getVendorExtensions(), (Map)foundTag.getVendorExtensions());
            }
            if (tag.getExternalDocs() == null || tag.getExternalDocs().getVendorExtensions().isEmpty()) continue;
            org.testng.Assert.assertEquals((Map)tag.getExternalDocs().getVendorExtensions(), (Map)foundTag.getExternalDocs().getVendorExtensions());
        }
    }

    private static void changeContent(File file) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        out.write(TEST_SKIP_OVERWRITE);
        ((Writer)out).close();
    }

    private static CodegenOperation findCodegenOperationByOperationId(Map<String, List<CodegenOperation>> paths, String operationId) {
        for (List<CodegenOperation> ops : paths.values()) {
            for (CodegenOperation co : ops) {
                if (!operationId.equals(co.operationId)) continue;
                return co;
            }
        }
        return null;
    }
}

