/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.InlineModelResolver;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.properties.Property;
import io.swagger.parser.SwaggerParser;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CodegenTest {
    @Test(description="handle simple composition")
    public void propertiesInComposedModelTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfProperties.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("RedisResource");
        CodegenModel composed = codegen.fromModel("RedisResource", model, swagger.getDefinitions());
        Assert.assertEquals((int)composed.vars.size(), (int)3);
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)0)).baseName, (String)"modelOneProp");
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)1)).baseName, (String)"properties");
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)2)).baseName, (String)"zones");
        Assert.assertNotNull((Object)composed.parent);
    }

    @Test(description="test sanitizeTag")
    public void sanitizeTagTest() {
        DefaultCodegen codegen = new DefaultCodegen();
        Assert.assertEquals((String)codegen.sanitizeTag("foo"), (String)"Foo");
        Assert.assertEquals((String)codegen.sanitizeTag("$foo!"), (String)"Foo");
        Assert.assertEquals((String)codegen.sanitizeTag("foo bar"), (String)"FooBar");
        Assert.assertEquals((String)codegen.sanitizeTag("foo_bar"), (String)"FooBar");
        Assert.assertEquals((String)codegen.sanitizeTag("foo1 bar2"), (String)"Foo1Bar2");
        Assert.assertEquals((String)codegen.sanitizeTag("foo bar 1"), (String)"FooBar1");
        Assert.assertEquals((String)codegen.sanitizeTag("1foo"), (String)"Class1foo");
    }

    @Test(description="test underscore")
    public void underscoreNamesTest() {
        DefaultCodegen codegen = new DefaultCodegen();
        Assert.assertEquals((String)DefaultCodegen.underscore((String)"foo"), (String)"foo");
        Assert.assertEquals((String)DefaultCodegen.underscore((String)"foo-bar"), (String)"foo_bar");
        Assert.assertEquals((String)DefaultCodegen.underscore((String)"foo bar"), (String)"foo_bar");
        Assert.assertEquals((String)DefaultCodegen.underscore((String)"FooBar"), (String)"foo_bar");
        Assert.assertEquals((String)DefaultCodegen.underscore((String)"FooBarBaz"), (String)"foo_bar_baz");
    }

    @Test(description="test camelize")
    public void camelizeNamesTest() {
        DefaultCodegen codegen = new DefaultCodegen();
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo"), (String)"Foo");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)".foo"), (String)"Foo");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)".foo.bar"), (String)"FooBar");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo$bar"), (String)"Foo$bar");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo_$bar"), (String)"Foo$bar");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo_bar"), (String)"FooBar");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo_bar_baz"), (String)"FooBarBaz");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo/bar.baz"), (String)"FooBarBaz");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"/foo/bar/baz.qux/corge"), (String)"FooBarBazQuxCorge");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo-bar"), (String)"FooBar");
        Assert.assertEquals((String)DefaultCodegen.camelize((String)"foo-bar-xyzzy"), (String)"FooBarXyzzy");
    }

    @Test(description="read a file upload param from a 2.0 spec")
    public void fileUploadParamTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pet/{petId}/uploadImage";
        Operation p = ((Path)model.getPaths().get("/pet/{petId}/uploadImage")).getPost();
        CodegenOperation op = codegen.fromOperation("/pet/{petId}/uploadImage", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.operationId, (String)"uploadFile");
        Assert.assertEquals((String)op.httpMethod, (String)"POST");
        Assert.assertTrue((boolean)op.hasConsumes);
        Assert.assertEquals((int)op.consumes.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.consumes.get(0)).get("mediaType")), (String)"multipart/form-data");
        Assert.assertTrue((boolean)op.hasProduces);
        Assert.assertEquals((int)op.allParams.size(), (int)3);
        Assert.assertEquals((int)op.formParams.size(), (int)2);
        CodegenParameter file = (CodegenParameter)op.formParams.get(1);
        Assert.assertTrue((boolean)file.isFormParam);
        Assert.assertEquals((String)file.dataType, (String)"File");
        Assert.assertFalse((boolean)file.required);
        Assert.assertTrue((boolean)file.isFile);
        Assert.assertFalse((boolean)file.hasMore);
    }

    @Test(description="read formParam values from a 2.0 spec")
    public void formParamTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pet/{petId}";
        Operation p = ((Path)model.getPaths().get("/pet/{petId}")).getPost();
        CodegenOperation op = codegen.fromOperation("/pet/{petId}", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.operationId, (String)"updatePetWithForm");
        Assert.assertEquals((String)op.httpMethod, (String)"POST");
        Assert.assertTrue((boolean)op.hasConsumes);
        Assert.assertEquals((int)op.consumes.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.consumes.get(0)).get("mediaType")), (String)"application/x-www-form-urlencoded");
        Assert.assertTrue((boolean)op.hasProduces);
        Assert.assertEquals((int)op.produces.size(), (int)2);
        Assert.assertEquals((String)((String)((Map)op.produces.get(0)).get("mediaType")), (String)"application/json");
        Assert.assertEquals((String)((String)((Map)op.produces.get(0)).get("hasMore")), (String)"true");
        Assert.assertEquals((String)((String)((Map)op.produces.get(1)).get("mediaType")), (String)"application/xml");
        Assert.assertEquals((int)op.pathParams.size(), (int)1);
        CodegenParameter idParam = (CodegenParameter)op.pathParams.get(0);
        Assert.assertTrue((boolean)idParam.isPathParam);
        Assert.assertEquals((String)idParam.dataType, (String)"String");
        Assert.assertTrue((boolean)idParam.required);
        Assert.assertFalse((boolean)idParam.hasMore);
        Assert.assertEquals((int)op.allParams.size(), (int)3);
        Assert.assertEquals((int)op.formParams.size(), (int)2);
        CodegenParameter nameParam = (CodegenParameter)op.formParams.get(0);
        Assert.assertTrue((boolean)nameParam.isFormParam);
        Assert.assertTrue((boolean)nameParam.notFile);
        Assert.assertEquals((String)nameParam.dataType, (String)"String");
        Assert.assertFalse((boolean)nameParam.required);
        Assert.assertTrue((boolean)nameParam.hasMore);
        CodegenParameter statusParam = (CodegenParameter)op.formParams.get(1);
        Assert.assertTrue((boolean)statusParam.isFormParam);
        Assert.assertTrue((boolean)statusParam.notFile);
        Assert.assertEquals((String)statusParam.dataType, (String)"String");
        Assert.assertFalse((boolean)statusParam.required);
        Assert.assertFalse((boolean)statusParam.hasMore);
    }

    @Test(description="handle enum array in query parameter test")
    public void enumArrayQueryParameterTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pet/findByStatus";
        Operation p = ((Path)model.getPaths().get("/pet/findByStatus")).getGet();
        CodegenOperation op = codegen.fromOperation("/pet/findByStatus", "get", p, model.getDefinitions());
        Assert.assertEquals((int)op.queryParams.size(), (int)1);
        CodegenParameter statusParam = (CodegenParameter)op.queryParams.get(0);
        Assert.assertEquals((String)statusParam.items.datatypeWithEnum, (String)"StatusEnum");
        Assert.assertNotNull((Object)statusParam.items);
        Assert.assertTrue((boolean)statusParam.items.isEnum);
        Assert.assertEquals((int)statusParam.items._enum.size(), (int)3);
    }

    @Test(description="handle enum in query parameter test")
    public void enumQueryParameterTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pet/findByStatus";
        Operation p = ((Path)model.getPaths().get("/pet/findByStatus")).getGet();
        CodegenOperation op = codegen.fromOperation("/pet/findByStatus", "get", p, model.getDefinitions());
        Assert.assertEquals((int)op.queryParams.size(), (int)1);
        CodegenParameter statusParam = (CodegenParameter)op.queryParams.get(0);
        Assert.assertEquals((String)statusParam.datatypeWithEnum, (String)"List");
        Assert.assertEquals((String)statusParam.baseType, (String)"String");
        Assert.assertTrue((boolean)statusParam.isEnum);
        Assert.assertEquals((int)((List)statusParam.allowableValues.get("values")).size(), (int)3);
    }

    @Test(description="handle required parameters from a 2.0 spec as required when figuring out Swagger types")
    public void requiredParametersTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/requiredTest.json");
        DefaultCodegen codegen = new DefaultCodegen(){

            public String getSwaggerType(Property p) {
                if (p != null && !p.getRequired()) {
                    return "Optional<" + super.getSwaggerType(p) + ">";
                }
                return super.getSwaggerType(p);
            }
        };
        String path = "/tests/requiredParams";
        Operation p = ((Path)model.getPaths().get("/tests/requiredParams")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/requiredParams", "get", p, model.getDefinitions());
        List formParams = op.formParams;
        Assert.assertEquals((int)formParams.size(), (int)2);
        Assert.assertEquals((String)((CodegenParameter)formParams.get((int)0)).dataType, (String)"Long");
        Assert.assertEquals((String)((CodegenParameter)formParams.get((int)1)).dataType, (String)"Optional<string>");
        Assert.assertEquals((String)op.returnType, (String)"Long");
    }

    @Test(description="select main response from a 2.0 spec using the lowest 2XX code")
    public void responseSelectionTest1() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/responseSelectionTest.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/withTwoHundredAndDefault";
        Operation p = ((Path)model.getPaths().get("/tests/withTwoHundredAndDefault")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/withTwoHundredAndDefault", "get", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"String");
    }

    @Test(description="select main response from a 2.0 spec using the default keyword when no 2XX code")
    public void responseSelectionTest2() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/responseSelectionTest.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/withoutTwoHundredButDefault";
        Operation p = ((Path)model.getPaths().get("/tests/withoutTwoHundredButDefault")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/withoutTwoHundredButDefault", "get", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"String");
    }

    @Test(description="return byte array when response format is byte")
    public void binaryDataTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/binaryDataTest.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/binaryResponse";
        Operation p = ((Path)model.getPaths().get("/tests/binaryResponse")).getPost();
        CodegenOperation op = codegen.fromOperation("/tests/binaryResponse", "post", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"byte[]");
        Assert.assertEquals((String)op.bodyParam.dataType, (String)"byte[]");
        Assert.assertTrue((boolean)op.bodyParam.isBinary);
        Assert.assertTrue((boolean)((CodegenResponse)op.responses.get((int)0)).isBinary);
    }

    @Test(description="return file when response format is file")
    public void fileResponeseTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/fileResponseTest.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/fileResponse";
        Operation p = ((Path)model.getPaths().get("/tests/fileResponse")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/fileResponse", "get", p, model.getDefinitions());
        Assert.assertEquals((String)op.returnType, (String)"File");
        Assert.assertTrue((boolean)((CodegenResponse)op.responses.get((int)0)).isFile);
        Assert.assertTrue((boolean)op.isResponseFile);
    }

    @Test(description="discriminator is present")
    public void discriminatorTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/discriminatorTest.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pets";
        Operation p = ((Path)model.getPaths().get("/pets")).getGet();
        CodegenOperation op = codegen.fromOperation("/pets", "get", p, model.getDefinitions());
        Assert.assertEquals((String)op.discriminator, (String)"className");
    }

    @Test(description="handle simple composition")
    public void simpleCompositionTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("SimpleComposition");
        CodegenModel composed = codegen.fromModel("SimpleComposition", model, swagger.getDefinitions());
        Assert.assertEquals((int)composed.vars.size(), (int)2);
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)0)).baseName, (String)"modelTwoProp");
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)1)).baseName, (String)"simpleCompositionProp");
        Assert.assertNotNull((Object)composed.parent);
    }

    @Test(description="handle multi level composition")
    public void multiCompositionTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("CompositionOfSimpleComposition");
        CodegenModel composed = codegen.fromModel("CompositionOfSimpleComposition", model, swagger.getDefinitions());
        Assert.assertEquals((int)composed.vars.size(), (int)2);
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)0)).baseName, (String)"modelThreeProp");
        Assert.assertEquals((String)((CodegenProperty)composed.vars.get((int)1)).baseName, (String)"compositionOfSimpleCompositionProp");
        Assert.assertNotNull((Object)composed.parent);
    }

    @Test(description="handle simple inheritance")
    public void simpleInheritanceTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("ChildOfSimpleParent");
        CodegenModel child = codegen.fromModel("ChildOfSimpleParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)3);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"disc");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)1)).baseName, (String)"simpleParentProp");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)2)).baseName, (String)"childOfSimpleParentProp");
        Assert.assertEquals((String)child.parent, (String)"ModelOne");
    }

    @Test(description="handle multi level inheritance")
    public void multiInheritanceTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("ChildOfChildOfSimpleParent");
        CodegenModel child = codegen.fromModel("ChildOfChildOfSimpleParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)1);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"childOfChildOfSimpleParentProp");
        Assert.assertEquals((String)child.parent, (String)"ChildOfSimpleParent");
    }

    @Test(description="copy properties in multi level inheritance if supportsInheritance is false")
    public void noSupportsInheritanceTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        Model model = (Model)swagger.getDefinitions().get("ChildOfChildOfSimpleParent");
        CodegenModel child = codegen.fromModel("ChildOfChildOfSimpleParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)5);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"modelOneProp");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)1)).baseName, (String)"disc");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)2)).baseName, (String)"simpleParentProp");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)3)).baseName, (String)"childOfSimpleParentProp");
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)4)).baseName, (String)"childOfChildOfSimpleParentProp");
        Assert.assertEquals((String)child.parent, (String)"ChildOfSimpleParent");
    }

    @Test(description="don't copy interfaces properties if supportsMixins is true")
    public void supportsMixinsTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        codegen.supportsMixins = true;
        Model model = (Model)swagger.getDefinitions().get("ChildOfChildOfSimpleParent");
        CodegenModel child = codegen.fromModel("ChildOfChildOfSimpleParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)1);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"childOfChildOfSimpleParentProp");
        Assert.assertEquals((int)child.allVars.size(), (int)5);
        Assert.assertEquals((String)((CodegenProperty)child.allVars.get((int)0)).baseName, (String)"modelOneProp");
        Assert.assertEquals((String)((CodegenProperty)child.allVars.get((int)1)).baseName, (String)"disc");
        Assert.assertEquals((String)((CodegenProperty)child.allVars.get((int)2)).baseName, (String)"simpleParentProp");
        Assert.assertEquals((String)((CodegenProperty)child.allVars.get((int)3)).baseName, (String)"childOfSimpleParentProp");
        Assert.assertEquals((String)((CodegenProperty)child.allVars.get((int)4)).baseName, (String)"childOfChildOfSimpleParentProp");
        Assert.assertEquals((String)child.parent, (String)"ChildOfSimpleParent");
    }

    @Test(description="handle inheritance from composed model")
    public void inheritanceOfComposedModelTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("ChildOfComposedParent");
        CodegenModel child = codegen.fromModel("ChildOfComposedParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)1);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"childOfComposedParentProp");
        Assert.assertEquals((String)child.parent, (String)"ComposedParent");
    }

    @Test(description="handle multi level inheritance from composed model")
    public void multiInheritanceOfComposedModelTest() {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/allOfTest.yaml");
        DefaultCodegen codegen = new DefaultCodegen();
        codegen.supportsInheritance = true;
        Model model = (Model)swagger.getDefinitions().get("ChildOfChildOfComposedParent");
        CodegenModel child = codegen.fromModel("ChildOfChildOfComposedParent", model, swagger.getDefinitions());
        Assert.assertEquals((int)child.vars.size(), (int)1);
        Assert.assertEquals((String)((CodegenProperty)child.vars.get((int)0)).baseName, (String)"childOfChildOfComposedParentProp");
        Assert.assertEquals((String)child.parent, (String)"ChildOfComposedParent");
    }

    @Test(description="use relative $ref for definitions of parameters")
    public void relativeDefinitionsInParameterTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/relative-ref/nested/directory/main/relative-refs.yml");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/photo/getPhotos";
        Operation p = ((Path)model.getPaths().get("/photo/getPhotos")).getPost();
        CodegenOperation op = codegen.fromOperation("/photo/getPhotos", "post", p, model.getDefinitions(), model);
        Assert.assertNotNull((Object)op);
        Assert.assertNotNull((Object)op.imports);
        Assert.assertTrue((boolean)op.imports.contains("Photo"));
        Assert.assertTrue((boolean)op.imports.contains("PhotosRequest"));
    }

    @Test(description="use relative $ref for definitions of response")
    public void relativeDefinitionsInResponseTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/relative-ref/nested/directory/main/relative-refs.yml");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/photo/{id}";
        Operation p = ((Path)model.getPaths().get("/photo/{id}")).getGet();
        CodegenOperation op = codegen.fromOperation("/photo/{id}", "get", p, model.getDefinitions(), model);
        Assert.assertNotNull((Object)op);
        Assert.assertNotNull((Object)op.imports);
        Assert.assertTrue((boolean)op.imports.contains("Photo"));
        Assert.assertTrue((boolean)op.imports.contains("integer"));
    }

    @Test(description="use relative $ref for definitions of response")
    public void relativeDefinitionsMapInResponseTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/relative-ref/nested/directory/main/relative-refs.yml");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/photo/thumbnails";
        Operation p = ((Path)model.getPaths().get("/photo/thumbnails")).getPost();
        CodegenOperation op = codegen.fromOperation("/photo/thumbnails", "post", p, model.getDefinitions(), model);
        Assert.assertNotNull((Object)op);
        Assert.assertNotNull((Object)op.imports);
        Assert.assertTrue((boolean)op.imports.contains("Photo"));
        Assert.assertTrue((boolean)op.imports.contains("PhotoThumbnailsRequest"));
    }

    @Test(description="use operation consumes and produces")
    public void localConsumesAndProducesTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/globalConsumesAndProduces.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/localConsumesAndProduces";
        Operation p = ((Path)model.getPaths().get("/tests/localConsumesAndProduces")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/localConsumesAndProduces", "get", p, model.getDefinitions(), model);
        Assert.assertTrue((boolean)op.hasConsumes);
        Assert.assertEquals((int)op.consumes.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.consumes.get(0)).get("mediaType")), (String)"application/json");
        Assert.assertTrue((boolean)op.hasProduces);
        Assert.assertEquals((int)op.produces.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.produces.get(0)).get("mediaType")), (String)"application/json");
    }

    @Test(description="use spec consumes and produces")
    public void globalConsumesAndProducesTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/globalConsumesAndProduces.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/globalConsumesAndProduces";
        Operation p = ((Path)model.getPaths().get("/tests/globalConsumesAndProduces")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/globalConsumesAndProduces", "get", p, model.getDefinitions(), model);
        Assert.assertTrue((boolean)op.hasConsumes);
        Assert.assertEquals((int)op.consumes.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.consumes.get(0)).get("mediaType")), (String)"application/global_consumes");
        Assert.assertTrue((boolean)op.hasProduces);
        Assert.assertEquals((int)op.produces.size(), (int)1);
        Assert.assertEquals((String)((String)((Map)op.produces.get(0)).get("mediaType")), (String)"application/global_produces");
    }

    @Test(description="use operation consumes and produces (reset in operation with empty array)")
    public void localResetConsumesAndProducesTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/globalConsumesAndProduces.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/tests/localResetConsumesAndProduces";
        Operation p = ((Path)model.getPaths().get("/tests/localResetConsumesAndProduces")).getGet();
        CodegenOperation op = codegen.fromOperation("/tests/localResetConsumesAndProduces", "get", p, model.getDefinitions(), model);
        Assert.assertNotNull((Object)op);
        Assert.assertFalse((boolean)op.hasConsumes);
        Assert.assertNull((Object)op.consumes);
        Assert.assertFalse((boolean)op.hasProduces);
        Assert.assertNull((Object)op.produces);
    }

    private static Swagger parseAndPrepareSwagger(String path) {
        Swagger swagger = new SwaggerParser().read(path);
        new InlineModelResolver().flatten(swagger);
        return swagger;
    }

    @Test(description="isDeprecated is present")
    public void deprecatedParamTest() {
        Swagger model = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.json");
        DefaultCodegen codegen = new DefaultCodegen();
        String path = "/pet/findByTags";
        Operation p = ((Path)model.getPaths().get("/pet/findByTags")).getGet();
        CodegenOperation op = codegen.fromOperation("/pet/findByTags", "get", p, model.getDefinitions());
        Assert.assertTrue((boolean)op.isDeprecated);
    }

    @Test(description="https://github.com/swagger-api/swagger-codegen/issues/7980")
    public void testPattern() throws Exception {
        Swagger swagger = CodegenTest.parseAndPrepareSwagger("src/test/resources/2_0/petstore.yaml");
        ModelImpl currency = (ModelImpl)swagger.getDefinitions().get("Currency");
        Assert.assertNotNull((Object)currency);
        Assert.assertEquals((String)currency.getPattern(), (String)"^[A-Z]{3,3}$");
        ModelImpl amount = (ModelImpl)swagger.getDefinitions().get("Amount");
        DefaultCodegen codegen = new DefaultCodegen();
        CodegenModel codegenModel = codegen.fromModel("Amount", (Model)amount, swagger.getDefinitions());
        for (CodegenProperty codegenProperty : codegenModel.vars) {
            if (!"currency".equalsIgnoreCase(codegenProperty.name)) continue;
            Assert.assertEquals((String)codegenProperty.pattern, (String)"^[A-Z]{3,3}$");
            break;
        }
    }
}

