/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.DefaultCodegen;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CodegenConfigLoaderTest {
    @DataProvider(name="codegenConfig")
    public Object[][] createCodegenConfigDataSet() throws Exception {
        Reflections reflections = new Reflections("io.swagger.codegen.languages", new Scanner[0]);
        Set subTypesOf = reflections.getSubTypesOf(DefaultCodegen.class);
        ArrayList<CodegenConfig> codegenConfigList = new ArrayList<CodegenConfig>();
        for (Class aClass : subTypesOf) {
            if (Modifier.isAbstract(aClass.getModifiers())) continue;
            DefaultCodegen defaultCodegen = (DefaultCodegen)aClass.newInstance();
            codegenConfigList.add((CodegenConfig)defaultCodegen);
        }
        Object[][] result = new Object[codegenConfigList.size()][1];
        for (int i = 0; i < codegenConfigList.size(); ++i) {
            result[i] = new Object[]{codegenConfigList.get(i)};
        }
        return result;
    }

    @Test(dataProvider="codegenConfig")
    public void testLoadByName(CodegenConfig codegenConfig) throws Exception {
        CodegenConfig loadedConfig = CodegenConfigLoader.forName((String)codegenConfig.getName());
        Assert.assertEquals(loadedConfig.getClass(), codegenConfig.getClass());
        Assert.assertEquals((String)loadedConfig.getName(), (String)codegenConfig.getName());
    }

    @Test(dataProvider="codegenConfig")
    public void testLoadByFullQualifiedName(CodegenConfig codegenConfig) throws Exception {
        CodegenConfig loadedConfig = CodegenConfigLoader.forName((String)codegenConfig.getClass().getName());
        Assert.assertEquals(loadedConfig.getClass(), codegenConfig.getClass());
        Assert.assertEquals((String)loadedConfig.getName(), (String)codegenConfig.getName());
    }
}

