/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.options.OptionsProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mockit.FullVerifications;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractOptionsTest {
    private final OptionsProvider optionsProvider;

    protected AbstractOptionsTest(OptionsProvider optionsProvider) {
        this.optionsProvider = optionsProvider;
    }

    @Test
    public void checkOptionsProcessing() {
        this.getCodegenConfig().additionalProperties().putAll(this.optionsProvider.createOptions());
        this.setExpectations();
        this.getCodegenConfig().processOpts();
        new FullVerifications(){};
    }

    @Test(description="check if all options described in documentation are presented in test case")
    public void checkOptionsHelp() {
        List cliOptions = Lists.transform((List)this.getCodegenConfig().cliOptions(), AbstractOptionsTest.getCliOptionTransformer());
        Set<String> testOptions = this.optionsProvider.createOptions().keySet();
        HashSet skipped = new HashSet(cliOptions);
        skipped.removeAll(testOptions);
        if (!skipped.isEmpty()) {
            Assert.fail((String)String.format("These options weren't checked: %s.", StringUtils.join(skipped, (String)", ")));
        }
        HashSet<String> undocumented = new HashSet<String>(testOptions);
        undocumented.removeAll(cliOptions);
        if (!undocumented.isEmpty()) {
            Assert.fail((String)String.format("These options weren't documented: %s.", StringUtils.join(undocumented, (String)", ")));
        }
    }

    private static Function<CliOption, String> getCliOptionTransformer() {
        return new Function<CliOption, String>(){

            public String apply(CliOption option) {
                return option.getOpt();
            }
        };
    }

    protected abstract CodegenConfig getCodegenConfig();

    protected abstract void setExpectations();
}

