/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.testutils.AssertFile;
import io.swagger.codegen.testutils.IntegrationTestPathsConfig;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.testng.annotations.Test;
import org.testng.reporters.Files;

public abstract class AbstractIntegrationTest {
    protected Boolean generateSwaggerMetadata = true;
    protected Map<String, String> systemPropertyOverrides = new HashMap<String, String>();

    protected abstract IntegrationTestPathsConfig getIntegrationTestPathsConfig();

    protected abstract CodegenConfig getCodegenConfig();

    protected abstract Map<String, String> configProperties();

    @Test(enabled=false)
    public void generatesCorrectDirectoryStructure() throws IOException {
        DefaultGenerator codeGen = new DefaultGenerator();
        codeGen.setGenerateSwaggerMetadata(this.generateSwaggerMetadata);
        for (Map.Entry<String, String> propertyOverride : this.systemPropertyOverrides.entrySet()) {
            codeGen.setGeneratorPropertyDefault(propertyOverride.getKey(), propertyOverride.getValue());
        }
        IntegrationTestPathsConfig integrationTestPathsConfig = this.getIntegrationTestPathsConfig();
        String specContent = Files.readFile((File)integrationTestPathsConfig.getSpecPath().toFile());
        Swagger swagger = new SwaggerParser().parse(specContent);
        CodegenConfig codegenConfig = this.getCodegenConfig();
        codegenConfig.setOutputDir(integrationTestPathsConfig.getOutputPath().toString());
        codegenConfig.setIgnoreFilePathOverride(integrationTestPathsConfig.getIgnoreFilePath().toFile().toString());
        ClientOpts clientOpts = new ClientOpts();
        clientOpts.setProperties(this.configProperties());
        ClientOptInput opts = new ClientOptInput().config(codegenConfig).opts(clientOpts).swagger(swagger);
        codeGen.opts(opts).generate();
        AssertFile.assertPathEqualsRecursively(integrationTestPathsConfig.getExpectedPath(), integrationTestPathsConfig.getOutputPath());
    }
}

