/*
 * Decompiled with CFR 0.152.
 */
package io.split.fastly.client;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionResolver {
    private static final Logger _log = LoggerFactory.getLogger(VersionResolver.class);
    private static VersionResolver _instance;
    private String _version;

    public String getVersion() {
        return this._version;
    }

    private VersionResolver() {
        this.setVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionResolver instance() {
        if (_instance != null) return _instance;
        Class<VersionResolver> clazz = VersionResolver.class;
        synchronized (VersionResolver.class) {
            if (_instance != null) return _instance;
            _instance = new VersionResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void setVersion() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            _log.warn("Fastly Client was unable to read version to include in headers. Defaulting in 'undefined'", (Throwable)e);
        }
        this._version = (String)props.getOrDefault((Object)"client.version", "undefined");
    }
}

