/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.CallbackState;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.EventState;
import io.serverlessworkflow.api.states.ForEachState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.states.SwitchState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class WorkflowUtils {
    private static final int DEFAULT_STARTING_STATE_POSITION = 0;
    private static final long DEFAULT_STATE_COUNT = 0L;

    public static State getStartingState(Workflow workflow) {
        if (!WorkflowUtils.hasStates(workflow)) {
            return null;
        }
        Start start = workflow.getStart();
        if (start == null) {
            return (State)workflow.getStates().get(0);
        }
        Optional<State> startingState = workflow.getStates().stream().filter(state -> state.getName().equals(start.getStateName())).findFirst();
        return startingState.orElse(null);
    }

    public static List<State> getStates(Workflow workflow, DefaultState.Type stateType) {
        if (!WorkflowUtils.hasStates(workflow)) {
            return null;
        }
        return workflow.getStates().stream().filter(state -> state.getType() == stateType).collect(Collectors.toList());
    }

    public static List<EventDefinition> getDefinedConsumedEvents(Workflow workflow) {
        return WorkflowUtils.getDefinedEvents(workflow, EventDefinition.Kind.CONSUMED);
    }

    public static List<EventDefinition> getDefinedProducedEvents(Workflow workflow) {
        return WorkflowUtils.getDefinedEvents(workflow, EventDefinition.Kind.PRODUCED);
    }

    public static List<EventDefinition> getDefinedEvents(Workflow workflow, EventDefinition.Kind eventKind) {
        if (!WorkflowUtils.hasEventDefs(workflow)) {
            return null;
        }
        List eventDefs = workflow.getEvents().getEventDefs();
        return eventDefs.stream().filter(eventDef -> eventDef.getKind() == eventKind).collect(Collectors.toList());
    }

    public static int getDefinedEventsCount(Workflow workflow, EventDefinition.Kind eventKind) {
        List<EventDefinition> definedEvents = WorkflowUtils.getDefinedEvents(workflow, eventKind);
        return definedEvents == null ? 0 : definedEvents.size();
    }

    public static int getDefinedConsumedEventsCount(Workflow workflow) {
        return WorkflowUtils.getDefinedEventsCount(workflow, EventDefinition.Kind.CONSUMED);
    }

    public static int getDefinedProducedEventsCount(Workflow workflow) {
        return WorkflowUtils.getDefinedEventsCount(workflow, EventDefinition.Kind.PRODUCED);
    }

    public static List<EventDefinition> getWorkflowConsumedEvents(Workflow workflow) {
        return WorkflowUtils.getWorkflowEventDefinitions(workflow, EventDefinition.Kind.CONSUMED);
    }

    public static List<EventDefinition> getWorkflowProducedEvents(Workflow workflow) {
        return WorkflowUtils.getWorkflowEventDefinitions(workflow, EventDefinition.Kind.PRODUCED);
    }

    public static List<EventDefinition> getWorkflowEventDefinitions(Workflow workflow, EventDefinition.Kind eventKind) {
        if (!WorkflowUtils.hasStates(workflow)) {
            return null;
        }
        List<String> uniqueWorkflowEventsFromStates = WorkflowUtils.getUniqueWorkflowEventsFromStates(workflow);
        List<EventDefinition> definedConsumedEvents = WorkflowUtils.getDefinedEvents(workflow, eventKind);
        if (definedConsumedEvents == null) {
            return null;
        }
        return definedConsumedEvents.stream().filter(definedEvent -> uniqueWorkflowEventsFromStates.contains(definedEvent.getName())).collect(Collectors.toList());
    }

    public static List<String> getUniqueWorkflowEventsFromStates(Workflow workflow) {
        ArrayList<String> eventReferences = new ArrayList<String>();
        for (State state : workflow.getStates()) {
            ParallelState parallelState;
            if (state instanceof SwitchState) {
                SwitchState switchState = (SwitchState)state;
                if (switchState.getEventConditions() == null) continue;
                switchState.getEventConditions().forEach(eventCondition -> eventReferences.add(eventCondition.getEventRef()));
                continue;
            }
            if (state instanceof CallbackState) {
                CallbackState callbackState = (CallbackState)state;
                if (callbackState.getEventRef() != null) {
                    eventReferences.add(callbackState.getEventRef());
                }
                if (callbackState.getAction() == null || callbackState.getAction().getEventRef() == null) continue;
                eventReferences.addAll(WorkflowUtils.getActionEvents(callbackState.getAction()));
                continue;
            }
            if (state instanceof EventState) {
                EventState eventState = (EventState)state;
                if (eventState.getOnEvents() == null) continue;
                eventState.getOnEvents().forEach(onEvents -> {
                    eventReferences.addAll(onEvents.getEventRefs());
                    if (onEvents.getActions() != null) {
                        for (Action action : onEvents.getActions()) {
                            eventReferences.addAll(WorkflowUtils.getActionEvents(action));
                        }
                    }
                });
                continue;
            }
            if (state instanceof OperationState) {
                OperationState operationState = (OperationState)state;
                if (operationState.getActions() == null) continue;
                for (Action action : operationState.getActions()) {
                    eventReferences.addAll(WorkflowUtils.getActionEvents(action));
                }
                continue;
            }
            if (!(state instanceof ParallelState) || (parallelState = (ParallelState)state).getBranches() == null) continue;
            for (Branch branch : parallelState.getBranches()) {
                if (branch.getActions() == null) continue;
                for (Action action : branch.getActions()) {
                    eventReferences.addAll(WorkflowUtils.getActionEvents(action));
                }
            }
        }
        return eventReferences.stream().distinct().collect(Collectors.toList());
    }

    public static int getWorkflowConsumedEventsCount(Workflow workflow) {
        List<EventDefinition> workflowConsumedEvents = WorkflowUtils.getWorkflowConsumedEvents(workflow);
        return workflowConsumedEvents == null ? 0 : workflowConsumedEvents.size();
    }

    public static int getWorkflowProducedEventsCount(Workflow workflow) {
        List<EventDefinition> workflowProducedEvents = WorkflowUtils.getWorkflowProducedEvents(workflow);
        return workflowProducedEvents == null ? 0 : workflowProducedEvents.size();
    }

    public static FunctionDefinition getFunctionDefinitionsForAction(Workflow workflow, String action) {
        if (!WorkflowUtils.hasFunctionDefs(workflow)) {
            return null;
        }
        FunctionRef functionRef = WorkflowUtils.getFunctionRefFromAction(workflow, action);
        if (functionRef == null) {
            return null;
        }
        Optional<FunctionDefinition> functionDefinition = workflow.getFunctions().getFunctionDefs().stream().filter(functionDef -> functionDef.getName().equals(functionRef.getRefName())).distinct().findFirst();
        return functionDefinition.isPresent() ? functionDefinition.get() : null;
    }

    public static List<Action> getActionsForFunctionDefinition(Workflow workflow, String functionDefinitionName) {
        if (!WorkflowUtils.hasFunctionDefs(workflow, functionDefinitionName)) {
            return null;
        }
        return WorkflowUtils.getActionsWhichUsesFunctionDefinition(workflow, functionDefinitionName);
    }

    public static long getNumOfStates(Workflow workflow) {
        return WorkflowUtils.hasStates(workflow) ? (long)workflow.getStates().size() : 0L;
    }

    public static long getNumOfStates(Workflow workflow, DefaultState.Type type) {
        return WorkflowUtils.hasStates(workflow) ? workflow.getStates().stream().filter(state -> state.getType() == type).count() : 0L;
    }

    public static State getStateWithName(Workflow workflow, String name) {
        if (!WorkflowUtils.hasStates(workflow)) {
            return null;
        }
        Optional<State> state = workflow.getStates().stream().filter(s -> s.getName().equals(name)).findFirst();
        if (state.isPresent()) {
            return state.get();
        }
        return null;
    }

    public static long getNumOfEndStates(Workflow workflow) {
        if (WorkflowUtils.hasStates(workflow)) {
            long count = workflow.getStates().stream().filter(state -> state.getEnd() != null).count();
            List switchStates = workflow.getStates().stream().filter(state -> state instanceof SwitchState).collect(Collectors.toList());
            for (State state2 : switchStates) {
                DefaultConditionDefinition defaultCondition;
                List dataConditions;
                SwitchState switchState = (SwitchState)state2;
                List eventConditions = switchState.getEventConditions();
                if (eventConditions != null) {
                    count += eventConditions.stream().filter(eventCondition -> eventCondition.getEnd() != null).count();
                }
                if ((dataConditions = switchState.getDataConditions()) != null) {
                    count += dataConditions.stream().filter(dataCondition -> dataCondition.getEnd() != null).count();
                }
                if ((defaultCondition = switchState.getDefaultCondition()) == null) continue;
                count = defaultCondition.getEnd() != null ? count + 1L : count;
            }
            return count;
        }
        return 0L;
    }

    public static List<Action> getActionsWhichUsesFunctionDefinition(Workflow workflow, String functionDefinitionName) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (State state : workflow.getStates()) {
            ForEachState forEachState;
            List forEachStateActions;
            if (state instanceof EventState) {
                EventState eventState = (EventState)state;
                List onEvents = eventState.getOnEvents();
                if (onEvents == null) continue;
                for (OnEvents onEvent : onEvents) {
                    List onEventActions;
                    if (onEvent == null || (onEventActions = onEvent.getActions()) == null) continue;
                    for (Action onEventAction : onEventActions) {
                        if (!WorkflowUtils.checkIfActionUsesFunctionDefinition(functionDefinitionName, onEventAction)) continue;
                        actions.add(onEventAction);
                    }
                }
                continue;
            }
            if (state instanceof CallbackState) {
                CallbackState callbackState = (CallbackState)state;
                Action callbackStateAction = callbackState.getAction();
                if (!WorkflowUtils.checkIfActionUsesFunctionDefinition(functionDefinitionName, callbackStateAction)) continue;
                actions.add(callbackStateAction);
                continue;
            }
            if (state instanceof OperationState) {
                OperationState operationState = (OperationState)state;
                List operationStateActions = operationState.getActions();
                if (operationStateActions == null) continue;
                for (Action operationStateAction : operationStateActions) {
                    if (!WorkflowUtils.checkIfActionUsesFunctionDefinition(functionDefinitionName, operationStateAction)) continue;
                    actions.add(operationStateAction);
                }
                continue;
            }
            if (state instanceof ParallelState) {
                ParallelState parallelState = (ParallelState)state;
                List parallelStateBranches = parallelState.getBranches();
                if (parallelStateBranches == null) continue;
                for (Branch branch : parallelStateBranches) {
                    List branchActions = branch.getActions();
                    if (branchActions == null) continue;
                    for (Action branchAction : branchActions) {
                        if (!WorkflowUtils.checkIfActionUsesFunctionDefinition(functionDefinitionName, branchAction)) continue;
                        actions.add(branchAction);
                    }
                }
                continue;
            }
            if (!(state instanceof ForEachState) || (forEachStateActions = (forEachState = (ForEachState)state).getActions()) == null) continue;
            for (Action forEachStateAction : forEachStateActions) {
                if (!WorkflowUtils.checkIfActionUsesFunctionDefinition(functionDefinitionName, forEachStateAction)) continue;
                actions.add(forEachStateAction);
            }
        }
        return actions;
    }

    public static boolean checkIfActionUsesFunctionDefinition(String functionDefinitionName, Action action) {
        return action != null && action.getFunctionRef() != null && action.getFunctionRef().getRefName() != null && action.getFunctionRef().getRefName().equals(functionDefinitionName);
    }

    public static boolean hasFunctionDefs(Workflow workflow, String functionDefinitionName) {
        if (!WorkflowUtils.hasFunctionDefs(workflow)) {
            return false;
        }
        List functionDefs = workflow.getFunctions().getFunctionDefs();
        return functionDefs.stream().anyMatch(functionDefinition -> functionDefinition.getName().equals(functionDefinitionName));
    }

    public static FunctionRef getFunctionRefFromAction(Workflow workflow, String action) {
        if (!WorkflowUtils.hasStates(workflow)) {
            return null;
        }
        for (State state : workflow.getStates()) {
            ForEachState forEachState;
            List forEachStateActions;
            if (state instanceof EventState) {
                EventState eventState = (EventState)state;
                List onEvents = eventState.getOnEvents();
                if (onEvents == null) continue;
                for (OnEvents onEvent : onEvents) {
                    List onEventActions;
                    if (onEvent == null || (onEventActions = onEvent.getActions()) == null) continue;
                    for (Action onEventAction : onEventActions) {
                        if (onEventAction == null || onEventAction.getName() == null || !onEventAction.getName().equals(action)) continue;
                        return onEventAction.getFunctionRef();
                    }
                }
                continue;
            }
            if (state instanceof CallbackState) {
                CallbackState callbackState = (CallbackState)state;
                Action callbackStateAction = callbackState.getAction();
                if (callbackStateAction == null || callbackStateAction.getName() == null || !callbackStateAction.getName().equals(action)) continue;
                return callbackStateAction.getFunctionRef();
            }
            if (state instanceof OperationState) {
                OperationState operationState = (OperationState)state;
                List operationStateActions = operationState.getActions();
                if (operationStateActions == null) continue;
                for (Action operationStateAction : operationStateActions) {
                    if (operationStateAction == null || operationStateAction.getName() == null || !operationStateAction.getName().equals(action)) continue;
                    return operationStateAction.getFunctionRef();
                }
                continue;
            }
            if (state instanceof ParallelState) {
                ParallelState parallelState = (ParallelState)state;
                List parallelStateBranches = parallelState.getBranches();
                if (parallelStateBranches == null) continue;
                for (Branch branch : parallelStateBranches) {
                    List branchActions = branch.getActions();
                    if (branchActions == null) continue;
                    for (Action branchAction : branchActions) {
                        if (branchAction == null || branchAction.getName() == null || !branchAction.getName().equals(action)) continue;
                        return branchAction.getFunctionRef();
                    }
                }
                continue;
            }
            if (!(state instanceof ForEachState) || (forEachStateActions = (forEachState = (ForEachState)state).getActions()) == null) continue;
            for (Action forEachStateAction : forEachStateActions) {
                if (forEachStateAction == null || forEachStateAction.getName() == null || !forEachStateAction.getName().equals(action)) continue;
                return forEachStateAction.getFunctionRef();
            }
        }
        return null;
    }

    public static boolean hasFunctionDefs(Workflow workflow) {
        return workflow != null && workflow.getFunctions() != null && workflow.getFunctions().getFunctionDefs() != null && !workflow.getFunctions().getFunctionDefs().isEmpty();
    }

    public static boolean hasStates(Workflow workflow) {
        return workflow != null && workflow.getStates() != null && !workflow.getStates().isEmpty();
    }

    public static boolean hasEventDefs(Workflow workflow) {
        return workflow != null && workflow.getEvents() != null && workflow.getEvents().getEventDefs() != null && !workflow.getEvents().getEventDefs().isEmpty();
    }

    public static List<String> getActionEvents(Action action) {
        ArrayList<String> actionEvents = new ArrayList<String>();
        if (action != null && action.getEventRef() != null) {
            if (action.getEventRef().getTriggerEventRef() != null) {
                actionEvents.add(action.getEventRef().getTriggerEventRef());
            }
            if (action.getEventRef().getResultEventRef() != null) {
                actionEvents.add(action.getEventRef().getResultEventRef());
            }
        }
        return actionEvents;
    }

    public static JsonNode mergeNodes(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = mainNode.get(fieldName);
            if (jsonNode != null && jsonNode.isObject()) {
                WorkflowUtils.mergeNodes(jsonNode, updateNode.get(fieldName));
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            JsonNode value = updateNode.get(fieldName);
            ((ObjectNode)mainNode).put(fieldName, value);
        }
        return mainNode;
    }

    public static JsonNode addNode(JsonNode mainNode, JsonNode toAddNode, String fieldName) {
        ((ObjectNode)mainNode).put(fieldName, toAddNode);
        return mainNode;
    }

    public static JsonNode addArray(JsonNode mainNode, ArrayNode toAddArray, String arrayName) {
        ((ObjectNode)mainNode).put(arrayName, (JsonNode)toAddArray);
        return mainNode;
    }

    public static JsonNode addFieldValue(JsonNode mainNode, Object toAddValue, String fieldName) {
        ObjectMapper mapper = new ObjectMapper();
        ((ObjectNode)mainNode).put(fieldName, mapper.valueToTree(toAddValue));
        return mainNode;
    }
}

