/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.repeat.Repeat;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"waitForCompletion", "workflowId", "usedForCompensation", "repeat"})
public class SubflowState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="waitForCompletion")
    @JsonPropertyDescription(value="Workflow execution must wait for local workflow to finish before continuing.")
    private boolean waitForCompletion = false;
    @JsonProperty(value="workflowId")
    @JsonPropertyDescription(value="Sub-workflow unique id.")
    @NotNull
    private String workflowId;
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    @JsonProperty(value="repeat")
    @Valid
    private Repeat repeat;
    private static final long serialVersionUID = -8841564117708202708L;

    public SubflowState() {
    }

    public SubflowState(String workflowId, String name, DefaultState.Type type) {
        super(name, type);
        this.workflowId = workflowId;
    }

    @JsonProperty(value="waitForCompletion")
    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    @JsonProperty(value="waitForCompletion")
    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public SubflowState withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @JsonProperty(value="workflowId")
    public String getWorkflowId() {
        return this.workflowId;
    }

    @JsonProperty(value="workflowId")
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public SubflowState withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SubflowState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @JsonProperty(value="repeat")
    public Repeat getRepeat() {
        return this.repeat;
    }

    @JsonProperty(value="repeat")
    public void setRepeat(Repeat repeat) {
        this.repeat = repeat;
    }

    public SubflowState withRepeat(Repeat repeat) {
        this.repeat = repeat;
        return this;
    }

    @Override
    public SubflowState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SubflowState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SubflowState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SubflowState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SubflowState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SubflowState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SubflowState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SubflowState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SubflowState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }
}

