/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"branches", "completionType", "n", "usedForCompensation"})
public class ParallelState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="branches")
    @JsonPropertyDescription(value="Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    @JsonProperty(value="completionType")
    @JsonPropertyDescription(value="Option types on how to complete branch execution.")
    private CompletionType completionType = CompletionType.fromValue("and");
    @JsonProperty(value="n")
    @JsonPropertyDescription(value="Used when completionType is set to 'n_of_m' to specify the 'N' value")
    private String n = "0";
    @JsonProperty(value="usedForCompensation")
    @JsonPropertyDescription(value="If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private static final long serialVersionUID = -837004419472118834L;

    public ParallelState() {
    }

    public ParallelState(List<Branch> branches, String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    @JsonProperty(value="branches")
    public List<Branch> getBranches() {
        return this.branches;
    }

    @JsonProperty(value="branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    @JsonProperty(value="completionType")
    public CompletionType getCompletionType() {
        return this.completionType;
    }

    @JsonProperty(value="completionType")
    public void setCompletionType(CompletionType completionType) {
        this.completionType = completionType;
    }

    public ParallelState withCompletionType(CompletionType completionType) {
        this.completionType = completionType;
        return this;
    }

    @JsonProperty(value="n")
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    public void setN(String n) {
        this.n = n;
    }

    public ParallelState withN(String n) {
        this.n = n;
        return this;
    }

    @JsonProperty(value="usedForCompensation")
    public boolean isUsedForCompensation() {
        return this.usedForCompensation;
    }

    @JsonProperty(value="usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ParallelState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public ParallelState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ParallelState withCompensatedBy(String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    public static enum CompletionType {
        AND("and"),
        XOR("xor"),
        N_OF_M("n_of_m");

        private final String value;
        private static final Map<String, CompletionType> CONSTANTS;

        private CompletionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CompletionType fromValue(String value) {
            CompletionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CompletionType>();
            for (CompletionType c : CompletionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

