/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.serverlessworkflow.api.interfaces.Extension;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ExtensionSerializer
extends StdSerializer<Extension> {
    private Map<String, Class<? extends Extension>> extensionsMap = new HashMap<String, Class<? extends Extension>>();

    public ExtensionSerializer() {
        this(Extension.class);
    }

    protected ExtensionSerializer(Class<Extension> t) {
        super(t);
    }

    public void addExtension(String extensionId, Class<? extends Extension> extensionClass) {
        this.extensionsMap.put(extensionId, extensionClass);
    }

    public void serialize(Extension extension, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String extensionId = extension.getExtensionId();
        if (!this.extensionsMap.containsKey(extensionId)) {
            throw new IllegalArgumentException("Extension handler not registered for: " + extensionId);
        }
        BeanSerializerFactory.instance.createSerializer(provider, TypeFactory.defaultInstance().constructType((Type)this.extensionsMap.get(extensionId))).serialize((Object)extension, gen, provider);
    }
}

