/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"error", "code", "retryRef", "transition", "end"})
public class Error
implements Serializable {
    @JsonProperty(value="error")
    @JsonPropertyDescription(value="Domain-specific error name, or '*' to indicate all possible errors")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String error;
    @JsonProperty(value="code")
    @JsonPropertyDescription(value="Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'")
    @Size(min=1)
    private @Size(min=1) String code;
    @JsonProperty(value="retryRef")
    @JsonPropertyDescription(value="References a unique name of a retry definition.")
    @Size(min=1)
    private @Size(min=1) String retryRef;
    @JsonProperty(value="transition")
    @Valid
    @NotNull
    private Transition transition;
    @JsonProperty(value="end")
    @JsonPropertyDescription(value="State end definition")
    @Valid
    private End end;
    private static final long serialVersionUID = -8933996684263594192L;

    public Error() {
    }

    public Error(String error, Transition transition) {
        this.error = error;
        this.transition = transition;
    }

    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    public void setError(String error) {
        this.error = error;
    }

    public Error withError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    public Error withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty(value="retryRef")
    public String getRetryRef() {
        return this.retryRef;
    }

    @JsonProperty(value="retryRef")
    public void setRetryRef(String retryRef) {
        this.retryRef = retryRef;
    }

    public Error withRetryRef(String retryRef) {
        this.retryRef = retryRef;
        return this;
    }

    @JsonProperty(value="transition")
    public Transition getTransition() {
        return this.transition;
    }

    @JsonProperty(value="transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Error withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    @JsonProperty(value="end")
    public End getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    public void setEnd(End end) {
        this.end = end;
    }

    public Error withEnd(End end) {
        this.end = end;
        return this;
    }
}

