/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.schedule.Schedule;
import io.serverlessworkflow.api.start.Start;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartDefinitionDeserializer
extends StdDeserializer<Start> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(StartDefinitionDeserializer.class);
    private WorkflowPropertySource context;

    public StartDefinitionDeserializer() {
        this(Start.class);
    }

    public StartDefinitionDeserializer(Class<?> vc) {
        super(vc);
    }

    public StartDefinitionDeserializer(WorkflowPropertySource context) {
        this(Start.class);
        this.context = context;
    }

    public Start deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Start start = new Start();
        if (!node.isObject()) {
            start.setStateName(node.asText());
            start.setSchedule(null);
            return start;
        }
        if (node.get("stateName") != null) {
            start.setStateName(node.get("stateName").asText());
        }
        if (node.get("schedule") != null) {
            start.setSchedule((Schedule)mapper.treeToValue((TreeNode)node.get("schedule"), Schedule.class));
        }
        return start;
    }
}

