/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.cron.Cron;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronDeserializer
extends StdDeserializer<Cron> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(CronDeserializer.class);
    private WorkflowPropertySource context;

    public CronDeserializer() {
        this(Cron.class);
    }

    public CronDeserializer(Class<?> vc) {
        super(vc);
    }

    public CronDeserializer(WorkflowPropertySource context) {
        this(Cron.class);
        this.context = context;
    }

    public Cron deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Cron cron = new Cron();
        if (!node.isObject()) {
            cron.setExpression(node.asText());
            return cron;
        }
        if (node.get("expression") != null) {
            cron.setExpression(node.get("expression").asText());
        }
        if (node.get("validUntil") != null) {
            cron.setValidUntil(node.get("validUntil").asText());
        }
        return cron;
    }
}

