
package io.serverlessworkflow.api.transitions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.produce.ProduceEvent;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "produceEvents",
    "nextState",
    "compensate"
})
public class Transition implements Serializable
{

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    @JsonPropertyDescription("Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    @JsonPropertyDescription("State to transition to next")
    @Size(min = 1)
    @NotNull
    private String nextState;
    /**
     * If set to true, triggers workflow compensation before this transition is taken. Default is false
     * 
     */
    @JsonProperty("compensate")
    @JsonPropertyDescription("If set to true, triggers workflow compensation before this transition is taken. Default is false")
    private boolean compensate = false;
    private final static long serialVersionUID = 9213732011354073065L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Transition() {
    }

    /**
     * 
     * @param nextState
     */
    public Transition(String nextState) {
        super();
        this.nextState = nextState;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return produceEvents;
    }

    /**
     * Array of events to be produced
     * 
     */
    @JsonProperty("produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public Transition withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public String getNextState() {
        return nextState;
    }

    /**
     * State to transition to next
     * (Required)
     * 
     */
    @JsonProperty("nextState")
    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public Transition withNextState(String nextState) {
        this.nextState = nextState;
        return this;
    }

    /**
     * If set to true, triggers workflow compensation before this transition is taken. Default is false
     * 
     */
    @JsonProperty("compensate")
    public boolean isCompensate() {
        return compensate;
    }

    /**
     * If set to true, triggers workflow compensation before this transition is taken. Default is false
     * 
     */
    @JsonProperty("compensate")
    public void setCompensate(boolean compensate) {
        this.compensate = compensate;
    }

    public Transition withCompensate(boolean compensate) {
        this.compensate = compensate;
        return this;
    }

}
