
package io.serverlessworkflow.api.switchconditions;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.interfaces.SwitchCondition;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Switch state data based condition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "condition",
    "transition",
    "end"
})
public class DataCondition implements Serializable, SwitchCondition
{

    /**
     * Data condition name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Data condition name")
    private String name;
    /**
     * Workflow expression evaluated against state data. True if results are not empty
     * (Required)
     * 
     */
    @JsonProperty("condition")
    @JsonPropertyDescription("Workflow expression evaluated against state data. True if results are not empty")
    @NotNull
    private String condition;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = 775469464427091300L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataCondition() {
    }

    /**
     * 
     * @param condition
     * @param transition
     */
    public DataCondition(String condition, Transition transition) {
        super();
        this.condition = condition;
        this.transition = transition;
    }

    /**
     * Data condition name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Data condition name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataCondition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Workflow expression evaluated against state data. True if results are not empty
     * (Required)
     * 
     */
    @JsonProperty("condition")
    public String getCondition() {
        return condition;
    }

    /**
     * Workflow expression evaluated against state data. True if results are not empty
     * (Required)
     * 
     */
    @JsonProperty("condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public DataCondition withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DataCondition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public DataCondition withEnd(End end) {
        this.end = end;
        return this;
    }

}
