
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.repeat.Repeat;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Defines a sub-workflow to be executed
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "waitForCompletion",
    "workflowId",
    "usedForCompensation",
    "repeat"
})
public class SubflowState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Workflow execution must wait for local workflow to finish before continuing.
     * 
     */
    @JsonProperty("waitForCompletion")
    @JsonPropertyDescription("Workflow execution must wait for local workflow to finish before continuing.")
    private boolean waitForCompletion = false;
    /**
     * Sub-workflow unique id.
     * (Required)
     * 
     */
    @JsonProperty("workflowId")
    @JsonPropertyDescription("Sub-workflow unique id.")
    @NotNull
    private java.lang.String workflowId;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    @JsonProperty("repeat")
    @Valid
    private Repeat repeat;
    private final static long serialVersionUID = -8841564117708202708L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SubflowState() {
    }

    /**
     * 
     * @param name
     * @param type
     * @param workflowId
     */
    public SubflowState(java.lang.String workflowId, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.workflowId = workflowId;
    }

    /**
     * Workflow execution must wait for local workflow to finish before continuing.
     * 
     */
    @JsonProperty("waitForCompletion")
    public boolean isWaitForCompletion() {
        return waitForCompletion;
    }

    /**
     * Workflow execution must wait for local workflow to finish before continuing.
     * 
     */
    @JsonProperty("waitForCompletion")
    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public SubflowState withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    /**
     * Sub-workflow unique id.
     * (Required)
     * 
     */
    @JsonProperty("workflowId")
    public java.lang.String getWorkflowId() {
        return workflowId;
    }

    /**
     * Sub-workflow unique id.
     * (Required)
     * 
     */
    @JsonProperty("workflowId")
    public void setWorkflowId(java.lang.String workflowId) {
        this.workflowId = workflowId;
    }

    public SubflowState withWorkflowId(java.lang.String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SubflowState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @JsonProperty("repeat")
    public Repeat getRepeat() {
        return repeat;
    }

    @JsonProperty("repeat")
    public void setRepeat(Repeat repeat) {
        this.repeat = repeat;
    }

    public SubflowState withRepeat(Repeat repeat) {
        this.repeat = repeat;
        return this;
    }

    @Override
    public SubflowState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SubflowState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SubflowState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SubflowState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SubflowState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SubflowState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SubflowState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SubflowState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SubflowState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

}
