
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Set up and inject the state's data input to data output. Does not perform any actions
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data",
    "usedForCompensation"
})
public class InjectState
    extends DefaultState
    implements Serializable, State
{

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("JSON object which can be set as states data input and can be manipulated via filters")
    @Valid
    private JsonNode data;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = -7542457903943733106L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public InjectState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public InjectState(java.lang.String name, DefaultState.Type type) {
        super(name, type);
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    public JsonNode getData() {
        return data;
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * 
     */
    @JsonProperty("data")
    public void setData(JsonNode data) {
        this.data = data;
    }

    public InjectState withData(JsonNode data) {
        this.data = data;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public InjectState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public InjectState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public InjectState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public InjectState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public InjectState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public InjectState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public InjectState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public InjectState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public InjectState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public InjectState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

}
